/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.Compiler.LG.JavaBlock;
import com.intersys.classes.Dictionary.ClassDefinition;
import com.intersys.classes.Dictionary.ForeignKeyDefinition;
import com.intersys.classes.Dictionary.IndexDefinition;
import com.intersys.classes.Dictionary.MethodDefinition;
import com.intersys.classes.Dictionary.PackageDefinition;
import com.intersys.classes.Dictionary.ParameterDefinition;
import com.intersys.classes.Dictionary.PropertyDefinition;
import com.intersys.classes.Dictionary.XDataDefinition;
import com.intersys.classes.RelationshipObject;
import com.intersys.classes.XSQL.DSI.JPAQuery;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectServerInfo;
import java.io.Writer;
import java.util.List;
import java.util.Set;

public class CacheDirectClassBuilder
extends CacheClassBuilder.InternalAPI {
    private Database mDB;
    private ClassDefinition cdef;
    private PropertyDefinition pdef;
    private MethodDefinition mdef;
    private XDataDefinition xData;
    private JavaBlock javaBlock;

    public CacheDirectClassBuilder(Database database) {
        this.mDB = database;
    }

    @Override
    public Object createEmptyClass(String string) throws Exception {
        this.newClassDefinition(string, true);
        this.cdef.setProcedureBlock(Boolean.TRUE);
        return this.cdef;
    }

    @Override
    public Object loadExistingClass(String string) throws Exception {
        this.newClassDefinition(string, false);
        return this.cdef;
    }

    @Override
    public void useProcedureBlock(Object object, boolean bl) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.cdef.setProcedureBlock(new Boolean(bl));
    }

    @Override
    public void addSuper(Object object, String string) throws Exception {
        String string2;
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        if ((string2 = this.cdef.getSuper()) == null || string2.length() == 0) {
            this.cdef.setSuper(string);
            return;
        }
        if (string2.indexOf(string) >= 0) {
            return;
        }
        this.cdef.setSuper(string2 + "," + string);
    }

    @Override
    public void defineIsPersistent(Object object) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.cdef.setClassType("persistent");
    }

    @Override
    public void defineIsSerial(Object object) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.cdef.setClassType("serial");
    }

    @Override
    public void defineIsDatatype(Object object) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.cdef.setClassType("datatype");
    }

    @Override
    public void defineIsAbstract(Object object) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.cdef.setAbstract(new Boolean(true));
    }

    @Override
    public void defineSystem(Object object, int n) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.cdef.setSystem(String.valueOf(n));
    }

    @Override
    public Object createParameter(Object object, String string, String string2) throws Exception {
        return this.createClassParameter(object, string, string2, "STRING");
    }

    @Override
    public Object createParameter(Object object, String string, int n) throws Exception {
        return this.createClassParameter(object, string, String.valueOf(n), "INTEGER");
    }

    @Override
    public Object createParameter(Object object, String string, boolean bl) throws Exception {
        return this.createClassParameter(object, string, String.valueOf(bl), "BOOLEAN");
    }

    @Override
    public Object createClassParameter(Object object, String string, Object object2, String string2) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        ParameterDefinition parameterDefinition = null;
        List list = this.cdef.getParameters().asList();
        for (ParameterDefinition parameterDefinition2 : list) {
            if (!string.equals(parameterDefinition2.getName())) continue;
            parameterDefinition = parameterDefinition2;
            break;
        }
        if (parameterDefinition == null) {
            parameterDefinition = new ParameterDefinition(this.mDB);
            parameterDefinition.setName(string);
            parameterDefinition.setparent(this.cdef);
            parameterDefinition.setFinal(Boolean.FALSE);
        }
        if (object2 == null) {
            parameterDefinition.setDefault(null);
        } else {
            parameterDefinition.setDefault(object2.toString());
        }
        if (string2 != null) {
            parameterDefinition.setType(string2);
        }
        return parameterDefinition;
    }

    @Override
    public void addPropertyParameter(Object object, String string, Object object2) throws Exception {
        if (object != null) {
            this.pdef = (PropertyDefinition)object;
        }
        this.pdef.getParameters().put(string, object2);
    }

    @Override
    public Object createProperty(Object object, String string) throws Exception {
        if (this.mMapper != null) {
            string = this.mMapper.replaceUnderscores(string);
        }
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        this.define(2010);
        this.define(2110, string);
        return this.pdef;
    }

    @Override
    public Object createIndex(Object object, String string, String string2, String string3, boolean bl, boolean bl2, String string4) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        if (string == null || string.length() == 0) {
            throw new CacheException("Index name is not defined in class " + this.cdef.getName() + " for index on properties: " + string3);
        }
        IndexDefinition indexDefinition = null;
        List list = this.cdef.getIndices().asList();
        for (IndexDefinition indexDefinition2 : list) {
            if (!string.equals(indexDefinition2.getName())) continue;
            indexDefinition = indexDefinition2;
            break;
        }
        if (indexDefinition == null) {
            indexDefinition = new IndexDefinition(this.mDB);
        }
        indexDefinition.setName(string);
        indexDefinition.setparent(this.cdef);
        indexDefinition.setProperties(string3);
        indexDefinition.setPrimaryKey(new Boolean(bl));
        indexDefinition.setUnique(new Boolean(bl2));
        indexDefinition.setSqlName(string2);
        if (string4 != null && string4.length() > 0) {
            indexDefinition.setType(string4);
        }
        return indexDefinition;
    }

    @Override
    public void createNamedQuery(String string, String string2, String string3) throws CacheException {
        if (JPAQuery.CACHE_CLASS_NAME((SysDatabase)this.mDB) == null) {
            throw new UnsupportedOperationException("Server does not support Named Queries. Your Server version is: " + this.mDB.getServerInfo().cacheObjectVersion + "\nNamed Queries are supported from 2008.2");
        }
        Boolean bl = JPAQuery.IDKExists(this.mDB, "9", string);
        if (bl != null && bl.booleanValue()) {
            JPAQuery.sys_DeleteQuery(this.mDB, string);
        }
        JPAQuery.sys_AddQuery(this.mDB, string, string2, string3);
    }

    @Override
    public Object createIDKey(Object object, String string, String string2, String string3) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        RelationshipObject relationshipObject = this.cdef.getIndices();
        Object object2 = relationshipObject.entrySet().iterator();
        while (object2.hasNext()) {
            IndexDefinition indexDefinition = (IndexDefinition)object2.next().getValue();
            if (!indexDefinition.getIdKey().booleanValue()) continue;
            object2.remove();
        }
        object2 = new IndexDefinition(this.mDB);
        ((IndexDefinition)object2).setName(string);
        ((IndexDefinition)object2).setparent(this.cdef);
        ((IndexDefinition)object2).setProperties(string3);
        ((IndexDefinition)object2).setIdKey(Boolean.TRUE);
        ((IndexDefinition)object2).setUnique(Boolean.TRUE);
        ((IndexDefinition)object2).setSqlName(string2);
        return object2;
    }

    @Override
    public Object createForeignKey(Object object, String string, String string2, String string3, String string4) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        ForeignKeyDefinition foreignKeyDefinition = new ForeignKeyDefinition(this.mDB);
        foreignKeyDefinition.setName(string);
        foreignKeyDefinition.setparent(this.cdef);
        foreignKeyDefinition.setProperties(string2);
        foreignKeyDefinition.setReferencedClass(string3);
        foreignKeyDefinition.setReferencedKey(string4);
        return foreignKeyDefinition;
    }

    @Override
    public Writer createXData(Object object, String string) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        List list = this.cdef.getXDatas().asList();
        boolean bl = false;
        for (XDataDefinition this.xData : list) {
            if (!string.equals(this.xData.getName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.xData = new XDataDefinition(this.mDB);
            this.xData.setparent(this.cdef);
            this.xData.setName(string);
        }
        CacheWriter cacheWriter = this.xData.getDataOut();
        return cacheWriter;
    }

    @Override
    public Object getClientProjectionSettings(Object object) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        if (this.javaBlock == null) {
            this.javaBlock = new JavaBlock(this.mDB);
        }
        return this.javaBlock;
    }

    @Override
    public void defineType(Object object, String string) throws Exception {
        this.pdef = (PropertyDefinition)object;
        this.pdef.setType(string);
    }

    @Override
    public void defineIsList(Object object) throws Exception {
        this.pdef = (PropertyDefinition)object;
        this.pdef.setCollection("list");
    }

    @Override
    public void defineIsArray(Object object) throws Exception {
        this.pdef = (PropertyDefinition)object;
        this.pdef.setCollection("array");
    }

    @Override
    public void defineIsTransient(Object object, boolean bl) throws Exception {
        this.pdef = (PropertyDefinition)object;
        this.pdef.setTransient(new Boolean(bl));
    }

    @Override
    public void defineIsRequired(Object object, boolean bl) throws Exception {
        this.pdef = (PropertyDefinition)object;
        this.pdef.setRequired(new Boolean(bl));
    }

    @Override
    public void defineRelationship(Object object, String string, String string2) throws Exception {
        if (object != null) {
            this.pdef = (PropertyDefinition)object;
        }
        this.pdef.setRelationship(Boolean.TRUE);
        this.pdef.setCardinality(string);
        this.pdef.setInverse(string2);
    }

    @Override
    public Object createMethod(Object object, String string) throws Exception {
        if (this.mMapper != null) {
            string = this.mMapper.replaceUnderscores(string);
        }
        this.cdef = (ClassDefinition)object;
        MethodDefinition methodDefinition = new MethodDefinition(this.mDB);
        methodDefinition.setName(string);
        methodDefinition.setparent(this.cdef);
        return methodDefinition;
    }

    @Override
    public void defineReturnType(Object object, String string) throws Exception {
        this.mdef = (MethodDefinition)object;
        this.mdef.setReturnType(string);
    }

    @Override
    public void defineIsFinal(Object object, boolean bl) throws Exception {
        if (object instanceof MethodDefinition) {
            this.mdef = (MethodDefinition)object;
            this.mdef.setFinal(new Boolean(bl));
        } else if (object instanceof ParameterDefinition) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)object;
            parameterDefinition.setFinal(new Boolean(bl));
        } else {
            throw new Exception("Unsupported type: " + object.getClass().getName());
        }
    }

    @Override
    public void defineIsStatic(Object object, boolean bl) throws Exception {
        this.mdef = (MethodDefinition)object;
        this.mdef.setClassMethod(new Boolean(bl));
    }

    @Override
    public void defineBody(Object object, String string) throws Exception {
        this.mdef = (MethodDefinition)object;
        CacheWriter cacheWriter = this.mdef.getImplementationOut();
        cacheWriter.write(string);
        ((Writer)cacheWriter).flush();
    }

    @Override
    public void defineArguments(Object object, String[] stringArray, String[] stringArray2, boolean[] blArray, String[] stringArray3) throws Exception {
        this.mdef = (MethodDefinition)object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (blArray != null && blArray[i]) {
                stringBuffer.append('&');
            }
            stringBuffer.append(stringArray2[i]).append(':').append(stringArray[i]);
            if (stringArray3 != null && stringArray3[i] != null) {
                stringBuffer.append('=').append(stringArray3[i]);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        this.mdef.setFormalSpec(stringBuffer.toString());
    }

    @Override
    public Object saveClass(Object object) throws Exception {
        if (object != null) {
            this.cdef = (ClassDefinition)object;
        }
        if (this.xData != null) {
            this.xData.save();
        }
        this.cdef.save();
        if (this.javaBlock != null) {
            this.javaBlock.sys_Save(this.cdef.getName());
        }
        return null;
    }

    @Override
    public void define(int n, Set set) throws Exception {
        switch (n) {
            case 120: {
                this.getClientProjectionSettings(null);
                List list = this.javaBlock.getAllowedExceptions();
                for (Class clazz : set) {
                    list.add(clazz.getName());
                }
                break;
            }
        }
    }

    @Override
    public void define(int n, String string) throws Exception {
        switch (n) {
            case 1: {
                throw new IllegalArgumentException("Use createEmptyClass() method instead.");
            }
            case 11: {
                this.cdef.setClientName(string);
                break;
            }
            case 15: {
                this.cdef.setSqlTableName(string);
                break;
            }
            case 51: {
                this.cdef.setSuper(string);
                break;
            }
            case 101: {
                this.getClientProjectionSettings(null);
                this.javaBlock.getPackage().setImplementation(string);
                break;
            }
            case 2110: {
                this.pdef.setName(string);
                break;
            }
            case 2130: {
                this.pdef.setClientName(string);
                break;
            }
            case 2140: {
                this.addPropertyParameter(null, "JAVATYPE", string);
                break;
            }
            case 2220: {
                this.addPropertyParameter(null, "MAXLEN", string);
                break;
            }
            case 2120: {
                this.pdef.setType(string);
                break;
            }
            case 2010: {
                this.getPropertyDefinition(string);
                break;
            }
            case 2020: {
                this.getPropertyDefinition(string);
                this.pdef.setCollection("array");
                break;
            }
            case 2030: {
                this.getPropertyDefinition(string);
                this.pdef.setCollection("list");
                break;
            }
            case 2050: {
                this.getPropertyDefinition(string);
                this.pdef.setRelationship(Boolean.TRUE);
                break;
            }
            case 2135: {
                this.pdef.setSqlFieldName(string);
            }
        }
    }

    @Override
    public void define(int n, int n2) throws Exception {
    }

    @Override
    public ObjectServerInfo getServerVersion() throws CacheException {
        return this.mDB.getServerInfo();
    }

    @Override
    public void setSchemaName(String string, String string2) throws CacheException {
        PackageDefinition packageDefinition = (PackageDefinition)PackageDefinition.open(this.mDB, new Id(string));
        packageDefinition.setSQLName(string2);
        packageDefinition.save();
        packageDefinition.release();
    }

    @Override
    public void define(int n) throws Exception {
        switch (n) {
            case 999: {
                this.checkClientName();
                this.cdef.save();
                break;
            }
            case 21: {
                this.cdef.setClassType("persistent");
                break;
            }
            case 31: {
                this.cdef.setAbstract(Boolean.TRUE);
                break;
            }
            case 22: {
                this.cdef.setClassType("serial");
                break;
            }
            case 2010: {
                this.newPropertyDefinition();
                break;
            }
            case 2020: {
                this.newPropertyDefinition();
                this.pdef.setCollection("array");
                break;
            }
            case 2030: {
                this.newPropertyDefinition();
                this.pdef.setCollection("list");
                break;
            }
            case 2050: {
                this.newPropertyDefinition();
                this.pdef.setRelationship(Boolean.TRUE);
                break;
            }
            case 3100: {
                this.addPropertyParameter(null, "CLASSNAME", new Integer(1));
                break;
            }
            case 2230: {
                this.defineIsRequired(this.pdef, true);
                break;
            }
            case 2900: {
                this.pdef.release();
            }
        }
    }

    private void checkClientName() throws CacheException {
        String string;
        String string2 = this.cdef.getClientName();
        if (string2 == null || string2.length() == 0) {
            string2 = this.cdef.getName();
        }
        try {
            string = ((SysDatabase)this.mDB).getDetachedObjectsManager().findCacheClassNameForPOJO(string2);
        }
        catch (Exception exception) {
            return;
        }
        if (string == null) {
            return;
        }
        if (string.equals(this.cdef.getName())) {
            return;
        }
        throw new CacheException("Java Class " + string2 + " is already mapped to class " + string + " in Cache. You are trying to remap it to class " + this.cdef.getName() + ". Delete Cache class " + string + " before proceeding.");
    }

    private void newPropertyDefinition() throws CacheException {
        this.pdef = new PropertyDefinition(this.mDB);
        this.pdef.setparent(this.cdef);
    }

    private void getPropertyDefinition(String string) throws CacheException {
        Id id = new Id(this.cdef.getName() + "||" + string);
        boolean bl = PropertyDefinition.exists(this.mDB, id);
        if (bl) {
            List list = this.cdef.getProperties().asList();
            this.pdef = null;
            for (PropertyDefinition this.pdef : list) {
                String string2 = this.pdef.getName();
                if (!string.equals(string2)) continue;
                break;
            }
            if (this.pdef == null) {
                throw new CacheException("Property " + string + " is not found in class " + this.cdef.getName());
            }
        } else {
            this.pdef = new PropertyDefinition(this.mDB);
            this.pdef.setparent(this.cdef);
            this.pdef.setName(string);
        }
    }

    private void newClassDefinition(String string, boolean bl) throws Exception {
        Id id = new Id(ClassDefinition.NormalizeClassname(this.mDB, string));
        boolean bl2 = ClassDefinition.exists(this.mDB, id);
        if (bl2) {
            if (bl) {
                this.mDB.utilities().deleteClassDefintion(string);
            } else {
                this.cdef = (ClassDefinition)ClassDefinition.open(this.mDB, id);
                this.javaBlock = JavaBlock.open(this.mDB, this.cdef.getName());
                return;
            }
        }
        this.mDB.utilities().unregisterGlobalForClass(string);
        this.cdef = new ClassDefinition(this.mDB);
        this.cdef.NameSet(string);
        this.javaBlock = null;
    }

    @Override
    public void close() {
        try {
            if (this.cdef != null) {
                this.cdef.release();
            }
            if (this.pdef != null) {
                this.pdef.release();
            }
            if (this.mdef != null) {
                this.mdef.release();
            }
            if (this.xData != null) {
                this.xData.release();
            }
            if (this.javaBlock != null) {
                this.javaBlock.release();
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }
}

