/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sql.plan.emf;

import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.model.sql.plan.emf.SQLPlanOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.models.planmodel.ESQLPlanNode;
import org.jkiss.dbeaver.models.planmodel.impl.ESQLPlanModelImpl;
import org.jkiss.utils.CommonUtils;

public class SQLPlan
extends ESQLPlanModelImpl {
    private final DBCPlan sourcePlan;
    private SQLPlanOwner ownerPart;
    private Map<Long, List<SQLPlanNode>> levels = new TreeMap<Long, List<SQLPlanNode>>();
    private List<SQLPlanNode> allNodes = new ArrayList<SQLPlanNode>();
    private List<SQLPlanNode> routePart = new ArrayList<SQLPlanNode>();
    private long maxLevelSize = 0L;

    public SQLPlan(SQLQuery query, DBCPlan plan) {
        this.sql = query.getText();
        this.sourcePlan = plan;
        List rootNodes = plan.getPlanNodes(Collections.emptyMap());
        long totalRows = 0L;
        for (DBCPlanNode srcNode : rootNodes) {
            SQLPlanNode planNode = this.makePlanNodeFromSource(srcNode);
            this.makeLevels(planNode);
            this.makeRoute(planNode);
            if (planNode.getParent() != null) continue;
            totalRows += planNode.getRows();
        }
        for (SQLPlanNode node : this.allNodes) {
            if (node.getParent() != null) continue;
            double newPercent = totalRows == 0L ? 0.0 : (double)node.getRows() / (double)totalRows;
            node.setPercent(newPercent);
        }
    }

    public DBCPlan getSourcePlan() {
        return this.sourcePlan;
    }

    public Map<Long, List<SQLPlanNode>> getLevels() {
        return this.levels;
    }

    public List<SQLPlanNode> getRoutePart() {
        return this.routePart;
    }

    private void addToIndex(SQLPlanNode node) {
        this.allNodes.add(node);
        Long currLevel = node.getLevel();
        List level = this.levels.computeIfAbsent(currLevel, k -> new ArrayList());
        level.add(node);
        if ((long)level.size() > this.maxLevelSize) {
            this.maxLevelSize = level.size();
        }
    }

    private static void addToList(SQLPlanNode node, List<SQLPlanNode> list) {
        list.add(node);
        for (ESQLPlanNode childNode : node.getChildNodes()) {
            SQLPlan.addToList((SQLPlanNode)childNode, list);
        }
    }

    public static List<SQLPlanNode> subTree(SQLPlanNode node) {
        ArrayList<SQLPlanNode> result = new ArrayList<SQLPlanNode>(1);
        for (ESQLPlanNode childNode : node.getChildNodes()) {
            SQLPlan.addToList((SQLPlanNode)childNode, result);
        }
        return result;
    }

    public List<SQLPlanNode> getAllNodes() {
        return this.allNodes;
    }

    public long getMaxLevelSize() {
        return this.maxLevelSize;
    }

    public void makeLevels(SQLPlanNode node) {
        this.addToIndex(node);
        for (ESQLPlanNode childNode : node.getChildNodes()) {
            SQLPlanNode p = (SQLPlanNode)childNode;
            this.makeLevels(p);
            p.setParent(node);
        }
    }

    public void makeRoute(SQLPlanNode node) {
        node.setHeavyRoute(true);
        boolean useCost = Boolean.TRUE.equals(node.getPlan().getSourcePlan().getPlanFeature("plan.cost"));
        boolean useDuration = !useCost && Boolean.TRUE.equals(node.getPlan().getSourcePlan().getPlanFeature("plan.cost"));
        double maxValue = 0.0;
        for (ESQLPlanNode child : node.getChildNodes()) {
            if (useCost) {
                if (!(child.getCost() > maxValue)) continue;
                maxValue = child.getCost();
                continue;
            }
            if (useDuration) {
                if (!(child.getDuration() > maxValue)) continue;
                maxValue = child.getDuration();
                continue;
            }
            if (!((double)child.getRows() > maxValue)) continue;
            maxValue = child.getRows();
        }
        if (maxValue > 0.0) {
            for (ESQLPlanNode child : node.getChildNodes()) {
                double d = useCost ? child.getCost() : (useDuration ? child.getDuration() : (double)child.getRows());
                if (d >= maxValue) {
                    this.makeRoute((SQLPlanNode)child);
                    continue;
                }
                if (child.getChildNodes().isEmpty()) continue;
                this.routePart.add((SQLPlanNode)child);
            }
        }
    }

    private SQLPlanNode makePlanNodeFromSource(DBCPlanNode srcNode) {
        double percentValue = 0.0;
        double durationValue = 0.0;
        double costValue = 0.0;
        long rowsValue = 0L;
        if (srcNode instanceof DBCPlanCostNode) {
            DBCPlanCostNode costNode = (DBCPlanCostNode)srcNode;
            percentValue = CommonUtils.toDouble((Object)costNode.getNodePercent());
            durationValue = CommonUtils.toDouble((Object)costNode.getNodeDuration());
            costValue = CommonUtils.toDouble((Object)costNode.getNodeCost());
            rowsValue = CommonUtils.toLong((Object)costNode.getNodeRowCount());
        }
        SQLPlanNode planNode = new SQLPlanNode(this, srcNode, percentValue, durationValue, costValue, rowsValue, srcNode.getNodeDescription(), 0L);
        planNode.setNodeType(srcNode.getNodeType());
        Collection childNodes = srcNode.getNested();
        if (childNodes != null) {
            long totalRows = 0L;
            for (DBCPlanNode childNode : childNodes) {
                SQLPlanNode childPlanNode = this.makePlanNodeFromSource(childNode);
                totalRows += childPlanNode.getRows();
                planNode.getChildNodes().add((Object)childPlanNode);
                childPlanNode.setParent(planNode);
            }
            if (totalRows != 0L) {
                for (ESQLPlanNode childPlanNode : planNode.getChildNodes()) {
                    childPlanNode.setPercent((double)childPlanNode.getRows() / (double)totalRows);
                }
            }
        }
        return planNode;
    }

    public SQLPlanOwner getOwnerPart() {
        return this.ownerPart;
    }

    public void setOwnerPart(SQLPlanOwner ownerPart) {
        this.ownerPart = ownerPart;
    }
}

