/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class NetezzaSQLDialect
extends GenericSQLDialect {
    private static final String[] OTHER_TYPES_FUNCTION = new String[]{"CURRENT_DB", "CURRENT_SID", "CURRENT_USERID", "CURRENT_USEROID", "CURRENT_CATALOG", "CURRENT_PATH", "CURRENT_SCHEMA", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TX_PATH", "CURRENT_TX_SCHEMA", "CURRENT_USER"};
    private static String[] NETEZZA_FUNCTIONS_DATETIME = new String[]{"DATE_PART", "DATE_TRUNC", "TIMEOFDAY"};
    private static String[] NETEZZA_FUNCTIONS = new String[]{"FIRST_VALUE", "LAG", "LAST_VALUE", "LEAD", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "VARIANCE", "VAR_POP", "VAR_SAMP"};
    private static String[] NETEZZA_KEYWORDS = new String[]{"ANALYZE", "COMMENT", "DECODE", "RESET", "DISTRIBUTE", "LOCK", "SHOW", "SYNONYM", "EXPRESS", "ONLINE", "RESET"};

    public NetezzaSQLDialect() {
        super("Netezza", "netezza");
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean isCatalogAtStart() {
        return true;
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (typeName.equals("INTERVAL")) {
            return null;
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public int getCatalogUsage() {
        return Integer.MAX_VALUE;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        this.addKeywords(Arrays.asList(OTHER_TYPES_FUNCTION), DBPKeywordType.OTHER);
        this.addFunctions(Arrays.asList(NETEZZA_FUNCTIONS_DATETIME));
        this.addFunctions(Arrays.asList(NETEZZA_FUNCTIONS));
        this.addKeywords(Arrays.asList(NETEZZA_KEYWORDS), DBPKeywordType.KEYWORD);
    }
}

