/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;

public class NetezzaGenericDatabase
extends GenericCatalog
implements DBPObjectStatistics {
    private static final Log log = Log.getLog(NetezzaGenericDatabase.class);
    private static final String CAT_STATS = "Statistics";
    private Long databaseFullSize;
    private Long databaseSize;
    private Long databaseFreeSize;

    public NetezzaGenericDatabase(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        super(dataSource, catalogName);
    }

    @Property(viewable=false, order=3, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getDatabaseSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.databaseSize;
    }

    @Property(viewable=false, order=4, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getDatabaseFullSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.databaseFullSize;
    }

    @Property(viewable=false, order=5, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getDatabaseFreeSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.databaseFreeSize;
    }

    public boolean hasStatistics() {
        return this.databaseSize != null;
    }

    public long getStatObjectSize() {
        return this.databaseSize == null ? 0L : this.databaseSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readStatistics(DBRProgressMonitor monitor) {
        if (this.hasStatistics()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read database statistics");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT\n\to.dbname AS DATABASENAME,\n\tSUM(z.ALLOCATED_BYTES) AS ALLOCATESPACE,\n\tSUM(z.Used_BYTES) AS USEDSPACE,\n\t(ALLOCATESPACE-USEDSPACE) AS FREESPACE\nFROM\n\tSYSTEM.DEFINITION_SCHEMA._V_SYS_OBJECT_STORAGE_SIZE z\nJOIN _v_object_data o ON\n\to.objid = z.tblid\nWHERE DATABASENAME = ?\nGROUP BY\n\to.dbname");){
                    dbStat.setString(1, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchStatistics(dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error reading table statistics", (Throwable)e);
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.databaseFullSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ALLOCATESPACE");
        this.databaseSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USEDSPACE");
        this.databaseFreeSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FREESPACE");
    }
}

