/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.shaded.apache.http.impl.cookie;

import com.simba.athena.shaded.apache.http.annotation.Contract;
import com.simba.athena.shaded.apache.http.annotation.ThreadingBehavior;
import com.simba.athena.shaded.apache.http.cookie.CommonCookieAttributeHandler;
import com.simba.athena.shaded.apache.http.cookie.Cookie;
import com.simba.athena.shaded.apache.http.cookie.CookieOrigin;
import com.simba.athena.shaded.apache.http.cookie.MalformedCookieException;
import com.simba.athena.shaded.apache.http.cookie.SetCookie;
import com.simba.athena.shaded.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.simba.athena.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

