/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.utils.rpc;

import com.simba.athena.jdbc.common.CustomNetworkHooksSettings;
import com.simba.athena.jdbc.core.DSDriver;
import com.simba.athena.jdbc.exceptions.CommonJDBCMessageKey;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import javax.net.SocketFactory;

public class CustomNetworkHooks {
    public static SocketFactory getCustomSocketFactory(CustomNetworkHooksSettings customNetworkHooksSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, customNetworkHooksSettings);
        SocketFactory socketFactory = null;
        if (null != customNetworkHooksSettings.m_socketFactory) {
            Class<SocketFactory> clazz = null;
            try {
                clazz = Class.forName(customNetworkHooksSettings.m_socketFactory).asSubclass(SocketFactory.class);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_CUSTOM_CLASS.name(), new String[]{customNetworkHooksSettings.m_socketFactory, exception.getClass().getName()});
                errorException.initCause(exception);
                throw errorException;
            }
            try {
                socketFactory = null != customNetworkHooksSettings.m_socketFactoryArg ? clazz.getConstructor(String.class).newInstance(customNetworkHooksSettings.m_socketFactoryArg) : clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_METHOD.name(), new String[]{customNetworkHooksSettings.m_socketFactory, exception.getClass().getName(), customNetworkHooksSettings.m_socketFactoryArg});
                errorException.initCause(exception);
                throw errorException;
            }
            return socketFactory;
        }
        return null;
    }
}

