/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.shaded.apache.http.Header;
import com.simba.athena.shaded.apache.http.HttpHost;
import com.simba.athena.shaded.apache.http.NameValuePair;
import com.simba.athena.shaded.apache.http.auth.AuthScope;
import com.simba.athena.shaded.apache.http.auth.UsernamePasswordCredentials;
import com.simba.athena.shaded.apache.http.client.CredentialsProvider;
import com.simba.athena.shaded.apache.http.client.config.RequestConfig;
import com.simba.athena.shaded.apache.http.client.entity.UrlEncodedFormEntity;
import com.simba.athena.shaded.apache.http.client.methods.HttpGet;
import com.simba.athena.shaded.apache.http.client.methods.HttpPost;
import com.simba.athena.shaded.apache.http.conn.ssl.NoopHostnameVerifier;
import com.simba.athena.shaded.apache.http.impl.client.BasicCredentialsProvider;
import com.simba.athena.shaded.apache.http.impl.client.CloseableHttpClient;
import com.simba.athena.shaded.apache.http.impl.client.HttpClients;
import com.simba.athena.shaded.apache.http.message.BasicNameValuePair;
import com.simba.athena.shaded.apache.http.util.EntityUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdfsCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");

    @Override
    protected String getSamlAssertion() throws IOException {
        if (StringUtils.isNullOrEmpty(this.m_idpHost)) {
            throw new IOException("Missing required property: idp_host");
        }
        if (StringUtils.isNullOrEmpty(this.m_userName) || StringUtils.isNullOrEmpty(this.m_password)) {
            return this.windowsIntegratedAuthentication();
        }
        return this.formBasedAuthentication();
    }

    @Override
    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractExecutable() throws IOException {
        File file = File.createTempFile("adfs", ".exe");
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = AdfsCredentialsProvider.class.getResourceAsStream("adfs.exe");
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy(inputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream, null);
            IOUtils.closeQuietly(fileOutputStream, null);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream, null);
        IOUtils.closeQuietly(fileOutputStream, null);
        return file;
    }

    private String formBasedAuthentication() throws IOException {
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=urn:amazon:webservices";
        CloseableHttpClient closeableHttpClient = null;
        try {
            String string2;
            Object object;
            Header[] headerArray;
            Cloneable cloneable;
            Object object3;
            Object object4;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                object4 = new BasicCredentialsProvider();
                object4.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object4).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                object3 = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                cloneable = RequestConfig.custom().setProxy((HttpHost)object3).build();
                httpGet.setConfig((RequestConfig)cloneable);
            }
            if ((object4 = closeableHttpClient.execute(httpGet)).getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + object4.getStatusLine().getReasonPhrase());
            }
            object3 = EntityUtils.toString(object4.getEntity());
            cloneable = new ArrayList(4);
            for (String object22 : this.getInputTagsfromHTML((String)object3)) {
                headerArray = this.getValueByKey(object22, "name");
                object = this.getValueByKey(object22, "value");
                string2 = headerArray.toLowerCase();
                if (string2.contains("username")) {
                    cloneable.add(new BasicNameValuePair((String)headerArray, this.m_userName));
                    continue;
                }
                if (string2.contains("authmethod")) {
                    if (((String)object).isEmpty()) continue;
                    cloneable.add(new BasicNameValuePair((String)headerArray, (String)object));
                    continue;
                }
                if (string2.contains("password")) {
                    cloneable.add(new BasicNameValuePair((String)headerArray, this.m_password));
                    continue;
                }
                if (headerArray.isEmpty()) continue;
                cloneable.add(new BasicNameValuePair((String)headerArray, (String)object));
            }
            String string3 = this.getFormAction((String)object3);
            if (!StringUtils.isNullOrEmpty(string3) && string3.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string3;
            }
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)((Object)cloneable)));
            object4 = closeableHttpClient.execute(httpPost);
            if (object4.getStatusLine().getStatusCode() != 200) {
                if (object4.getStatusLine().getStatusCode() == 302) {
                    headerArray = object4.getHeaders("Location");
                    object = null;
                    if (headerArray != null && headerArray.length > 0) {
                        object = headerArray[0].getValue();
                        object4 = closeableHttpClient.execute(new HttpPost((String)object));
                    }
                } else {
                    throw new IOException("Failed send request: " + object4.getStatusLine().getReasonPhrase());
                }
            }
            if (!((Matcher)(object = SAML_PATTERN.matcher((CharSequence)(headerArray = EntityUtils.toString(object4.getEntity()))))).find()) {
                throw new IOException("Failed to login ADFS.");
            }
            string2 = ((Matcher)object).group(1);
            return string2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly(closeableHttpClient, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String windowsIntegratedAuthentication() {
        String string;
        String string2 = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        if (!string2.contains("windows")) {
            throw new SdkClientException("WIA only support Windows platform.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        File file = null;
        try {
            file = this.extractExecutable();
            String[] stringArray = new String[5];
            stringArray[0] = file.getAbsolutePath();
            stringArray[1] = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=urn:amazon:webservices";
            stringArray[2] = String.valueOf(Boolean.getBoolean("adfs.insecure"));
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                stringArray[3] = this.m_proxyUid;
                stringArray[4] = this.m_proxyPwd;
            }
            Process process = Runtime.getRuntime().exec(stringArray);
            inputStream = process.getInputStream();
            outputStream = process.getOutputStream();
            String string3 = IOUtils.toString(inputStream);
            int n = process.waitFor();
            if (n != 0) {
                throw new SdkClientException("Failed execute adfs command, return: " + n);
            }
            string = string3;
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new SdkClientException("Failed execute adfs command.", interruptedException);
                catch (IOException iOException) {
                    throw new SdkClientException("Failed execute adfs command.", iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream, null);
                IOUtils.closeQuietly(outputStream, null);
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream, null);
        IOUtils.closeQuietly(outputStream, null);
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
        return string;
    }
}

