/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.dataengine.impl;

import com.simba.athena.dsi.core.impl.DSIDriver;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.dsi.exceptions.InvalidArgumentException;
import com.simba.athena.dsi.utilities.DSIMessageKey;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.List;

public class DSITableTypeOnlyMetadataSource
implements IMetadataSource {
    private boolean m_isFetching = false;
    private int m_currentIndex = 0;
    List<String> m_tableTypes = new ArrayList<String>();
    private ILogger m_logger;

    public DSITableTypeOnlyMetadataSource(ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_tableTypes.add("SYSTEM TABLE");
        this.m_tableTypes.add("TABLE");
        this.m_tableTypes.add("VIEW");
    }

    public DSITableTypeOnlyMetadataSource(ILogger iLogger, List<String> list) {
        LogUtilities.logFunctionEntrance(iLogger, iLogger, list);
        if (null == list) {
            throw new InvalidArgumentException(2, "tableTypes");
        }
        this.m_logger = iLogger;
        this.m_tableTypes = list;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isFetching = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_tableTypes.get(this.m_currentIndex), dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{metadataSourceColumnTag.toString()}, ExceptionType.DEFAULT);
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_tableTypes.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            ++this.m_currentIndex;
        } else {
            this.m_isFetching = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_tableTypes.size();
    }
}

