/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.utilities;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.BasicAWSCredentials;
import com.simba.athena.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.simba.athena.amazonaws.services.athena.model.ResultSetMetadata;
import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJEscapedQuery;
import com.simba.athena.athena.dataengine.AJReplacer;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.iamsupport.IPlugin;
import com.simba.athena.iamsupport.model.PluginProfilesConfiguration;
import com.simba.athena.shaded.apache.commons.csv.CSVFormat;
import com.simba.athena.shaded.apache.commons.csv.CSVParser;
import com.simba.athena.shaded.apache.commons.csv.CSVRecord;
import com.simba.athena.shaded.fasterxml.jackson.databind.DeserializationFeature;
import com.simba.athena.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.JDBCEscaper;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AJUtilities {
    private static final ObjectMapper s_objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    public static AWSCredentialsProvider createAwsStaticCredentialsProvider(ILogger iLogger, String string, String string2) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(string, string2);
        return new AWSStaticCredentialsProvider(basicAWSCredentials);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AWSCredentialsProvider createAwsCredentialsProvider(ILogger iLogger, AJSettings aJSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String string = aJSettings.m_uid;
        String string2 = aJSettings.m_pwd;
        String string3 = aJSettings.m_awsCredentialsProviderClass;
        List<String> list = aJSettings.m_awsCredentialProviderArgs;
        String string4 = aJSettings.m_profile;
        if (null != string3 && !string3.isEmpty()) {
            if (null != string4 && !string4.isEmpty()) {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.CREATE_AWS_CREDENTIALS_PROVIDER_ERR.name(), "The values of the connection properties profile is in conflict with AwsCredentialsProviderClass");
            }
            try {
                Object object;
                AWSCredentialsProvider aWSCredentialsProvider;
                Class<AWSCredentialsProvider> clazz = Class.forName(string3).asSubclass(AWSCredentialsProvider.class);
                if (null == list || list.isEmpty()) {
                    aWSCredentialsProvider = clazz.newInstance();
                } else {
                    object = new Class[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        object[i] = String.class;
                    }
                    Constructor<AWSCredentialsProvider> constructor = clazz.getConstructor((Class<?>)object);
                    aWSCredentialsProvider = constructor.newInstance(list.toArray());
                }
                if (null == aWSCredentialsProvider) return aWSCredentialsProvider;
                if (!(aWSCredentialsProvider instanceof IPlugin)) return aWSCredentialsProvider;
                object = (IPlugin)aWSCredentialsProvider;
                boolean bl = false;
                for (Map.Entry entry : aJSettings.m_pluginArgs.entrySet()) {
                    object.addParameter((String)entry.getKey(), (String)entry.getValue());
                    if (bl || !((String)entry.getKey()).equalsIgnoreCase("AwsRegion")) continue;
                    bl = true;
                }
                if (!bl) {
                    object.addParameter("AwsRegion", aJSettings.m_awsRegion);
                }
                if (!aJSettings.m_useOktaMFA) return aWSCredentialsProvider;
                object.addParameter("UseOktaMFA", String.valueOf(aJSettings.m_useOktaMFA));
                return aWSCredentialsProvider;
            }
            catch (Exception exception) {
                ErrorException errorException = AJDriver.s_AJMessages.createGeneralException(AJMessageKey.CREATE_AWS_CREDENTIALS_PROVIDER_ERR.name(), string3);
                errorException.initCause(exception);
                LogUtilities.logError(errorException, iLogger);
                if (null == string) throw errorException;
                if (null == string2) throw errorException;
                return AJUtilities.createAwsStaticCredentialsProvider(iLogger, string, string2);
            }
        } else {
            if (null == aJSettings.m_profile) return AJUtilities.createAwsStaticCredentialsProvider(iLogger, string, string2);
            if (aJSettings.m_profile.isEmpty()) return AJUtilities.createAwsStaticCredentialsProvider(iLogger, string, string2);
            PluginProfilesConfiguration pluginProfilesConfiguration = new PluginProfilesConfiguration(aJSettings);
            return new ProfileCredentialsProvider(pluginProfilesConfiguration, aJSettings.m_profile);
        }
    }

    public static ResultSetMetadata deserializeResultSetMetadata(String string) throws Exception {
        return s_objectMapper.readValue(string, ResultSetMetadata.class);
    }

    private static int findEndOfComments(String string, int n) {
        boolean bl;
        String string2 = string.substring(n, n + 2);
        if (string2.equals("--")) {
            bl = true;
        } else if (string2.equals("/*")) {
            bl = false;
        } else {
            return -1;
        }
        for (int i = n + 2; i < string.length(); ++i) {
            if (bl && '\n' == string.charAt(i)) {
                return i;
            }
            if (bl || '*' != string.charAt(i) || i + 1 >= string.length() || '/' != string.charAt(i + 1)) continue;
            return i + 1;
        }
        if (bl) {
            return string.length() - 1;
        }
        return -1;
    }

    private static int findEndOfStringLiteralOrQuotedIdentifier(String string, int n) {
        char c;
        if ('\'' == string.charAt(n)) {
            c = '\'';
        } else if ('\"' == string.charAt(n)) {
            c = '\"';
        } else {
            return -1;
        }
        for (int i = n + 1; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            if (i + 1 < string.length() && '\'' == string.charAt(i + 1)) {
                ++i;
                continue;
            }
            return i;
        }
        return -1;
    }

    public static Row deserializeRow(String string) throws Exception {
        return s_objectMapper.readValue(string, Row.class);
    }

    public static void parseCellAsTabDelimited(ILogger iLogger, String string, int n, List<String> list) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String[] stringArray = string.split("\t");
        int n2 = 0;
        while (n2 < stringArray.length) {
            list.add(stringArray[n2]);
            if (n > ++n2) continue;
            return;
        }
        while (n > n2) {
            list.add(null);
            ++n2;
        }
    }

    public static void parseCredentialsProviderArgs(ILogger iLogger, String string, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        StringReader stringReader = new StringReader(string);
        try {
            CSVParser cSVParser = CSVFormat.DEFAULT.withEscape('\\').withIgnoreSurroundingSpaces(true).parse(stringReader);
            for (CSVRecord cSVRecord : cSVParser) {
                Iterator<String> iterator = cSVRecord.iterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
        }
        catch (Exception exception) {
            ErrorException errorException = AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PARSE_AWS_CREDENTIALS_PROVIDER_ARGS_ERR.name(), string);
            errorException.initCause(exception);
            LogUtilities.logError(errorException, iLogger);
            throw errorException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AJEscapedQuery removeEscapeSequencesAndDetermineStmtType(String string, JDBCEscaper jDBCEscaper, AJReplacer aJReplacer) throws ErrorException {
        AJEscapedQuery aJEscapedQuery = new AJEscapedQuery();
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        aJEscapedQuery.m_escapedQuery = "";
        aJEscapedQuery.m_erroMessage = "";
        aJEscapedQuery.m_stmtType = AJStatementType.ROW_COUNT_STATEMENT;
        int n4 = 0;
        while (n4 < string.length()) {
            block18: {
                block19: {
                    block17: {
                        if ((n4 + 1 >= string.length() || '-' != string.charAt(n4) || '-' != string.charAt(n4 + 1)) && ('/' != string.charAt(n4) || '*' != string.charAt(n4 + 1))) break block17;
                        int n5 = AJUtilities.findEndOfComments(string, n4);
                        if (n5 == -1) {
                            aJEscapedQuery.m_erroMessage = "\r\n Query string has malformed comments at char " + n4;
                            aJEscapedQuery.m_escapedQuery = string;
                            return aJEscapedQuery;
                        }
                        n4 = n5;
                        break block18;
                    }
                    if (bl || Character.isWhitespace(string.charAt(n4))) break block19;
                    bl = true;
                    String string2 = string.substring(n4).trim().toUpperCase();
                    if (string2.startsWith("SELECT") || string2.startsWith("WITH") || string2.startsWith("USING") || string2.startsWith("VALUES")) {
                        aJEscapedQuery.m_stmtType = AJStatementType.SELECT_OR_VALUES_STATEMENT;
                        break block18;
                    } else if (string2.startsWith("SHOW") || string2.startsWith("DESCRIBE")) {
                        aJEscapedQuery.m_stmtType = AJStatementType.SHOW_OR_DESCRIBE_STATEMENT;
                    }
                    break block18;
                }
                if ('\'' == string.charAt(n4) || '\"' == string.charAt(n4)) {
                    int n6 = AJUtilities.findEndOfStringLiteralOrQuotedIdentifier(string, n4);
                    if (n6 == -1) {
                        aJEscapedQuery.m_erroMessage = "\r\n Query string has malformed quotes at char " + n4;
                        aJEscapedQuery.m_escapedQuery = string;
                        return aJEscapedQuery;
                    }
                    n4 = n6;
                } else if ('{' == string.charAt(n4)) {
                    if (0 == n3) {
                        n = n4;
                        aJEscapedQuery.m_escapedQuery = aJEscapedQuery.m_escapedQuery + string.substring(n2 + 1, n);
                    }
                    ++n3;
                } else if ('}' == string.charAt(n4)) {
                    if (0 == n3) {
                        aJEscapedQuery.m_erroMessage = "\r\n Query string has malformed escaped sequence at char " + n4;
                        aJEscapedQuery.m_escapedQuery = string;
                        return aJEscapedQuery;
                    }
                    if (0 == --n3) {
                        String string3 = string.substring(n, n4 + 1);
                        String string4 = jDBCEscaper.Apply(aJReplacer, string3);
                        aJEscapedQuery.m_escapedQuery = aJEscapedQuery.m_escapedQuery + string4;
                        n = -1;
                        n2 = n4;
                    }
                }
            }
            if (string.length() - 1 == n4 && n4 != n2) {
                if (0 == n3) {
                    aJEscapedQuery.m_escapedQuery = aJEscapedQuery.m_escapedQuery + string.substring(n2 + 1, n4 + 1);
                } else {
                    aJEscapedQuery.m_erroMessage = "\r\n Query string had malformed escape sequence. Missing closing }.";
                    aJEscapedQuery.m_escapedQuery = string;
                }
            }
            ++n4;
        }
        return aJEscapedQuery;
    }

    public static String rtrim(String string) {
        return RTRIM.matcher(string).replaceAll("");
    }
}

