/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.core.AJStatement;
import com.simba.athena.athena.dataengine.AJEscapedQuery;
import com.simba.athena.athena.dataengine.AJQueryExecutor;
import com.simba.athena.athena.dataengine.AJReplacer;
import com.simba.athena.athena.dataengine.metadata.AJCatalogOnlyMetadataSource;
import com.simba.athena.athena.dataengine.metadata.AJCatalogSchemaOnlyMetadataSource;
import com.simba.athena.athena.dataengine.metadata.AJColumnsMetadataSource;
import com.simba.athena.athena.dataengine.metadata.AJSchemaOnlyMetadataSource;
import com.simba.athena.athena.dataengine.metadata.AJTablesMetadataSource;
import com.simba.athena.athena.dataengine.metadata.AJTypeInfoMetadataSource;
import com.simba.athena.athena.utilities.AJUtilities;
import com.simba.athena.dsi.dataengine.filters.DSIMetadataFilterFactory;
import com.simba.athena.dsi.dataengine.filters.IFilter;
import com.simba.athena.dsi.dataengine.impl.DSIDataEngine;
import com.simba.athena.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.simba.athena.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.athena.dsi.dataengine.interfaces.IResultSet;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceID;
import com.simba.athena.dsi.dataengine.utilities.OrderType;
import com.simba.athena.dsi.exceptions.ParsingException;
import com.simba.athena.dsi.utilities.DSIMessageKey;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.JDBCEscaper;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AJDataEngine
extends DSIDataEngine {
    private IWarningListener m_warningListener;
    private boolean m_isDirectExecute;
    private AJConnection m_connection;
    private AJClient m_client;
    private final AJSettings m_settings;
    private final String m_catalog;
    private ArrayList<String> m_filterValues;
    private String m_quoteChar;
    private String m_escapeChar;
    private List<String> m_tableTypes = new ArrayList<String>();
    private JDBCEscaper m_jdbcEscaper = new JDBCEscaper();
    private AJReplacer m_replacer = new AJReplacer();

    public AJDataEngine(AJStatement aJStatement, AJSettings aJSettings, String string) {
        super(aJStatement);
        LogUtilities.logFunctionEntrance(this.getLog(), aJStatement);
        this.m_warningListener = this.getWarningListener();
        this.m_connection = (AJConnection)aJStatement.getParentConnection();
        this.m_client = this.m_connection.getClient();
        this.m_settings = aJSettings;
        this.m_catalog = string;
        if (null != this.m_settings.m_customTableTypesList && !this.m_settings.m_customTableTypesList.isEmpty()) {
            List<String> list = Arrays.asList(this.m_settings.m_customTableTypesList.split(","));
            for (String string2 : list) {
                this.m_tableTypes.add(string2.trim());
            }
        } else {
            this.m_tableTypes.add("TABLE");
            this.m_tableTypes.add("VIEW");
            this.m_tableTypes.add("EXTERNAL_TABLE");
            this.m_tableTypes.add("MANAGED_TABLE");
            this.m_tableTypes.add("VIRTUAL_VIEW");
        }
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{metadataSourceID, arrayList, string, string2, bl});
        this.m_filterValues = arrayList;
        this.m_quoteChar = string2;
        this.m_escapeChar = string;
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl);
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{metadataSourceID, arrayList, string, string2, bl, orderType});
        this.m_filterValues = arrayList;
        this.m_quoteChar = string2;
        this.m_escapeChar = string;
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        LogUtilities.logDebug("Query before escape: " + string, this.getLog());
        AJEscapedQuery aJEscapedQuery = AJUtilities.removeEscapeSequencesAndDetermineStmtType(string, this.m_jdbcEscaper, this.m_replacer);
        if (!aJEscapedQuery.m_erroMessage.isEmpty()) {
            LogUtilities.logDebug(aJEscapedQuery.m_erroMessage, this.getLog());
        }
        LogUtilities.logDebug("Query after escape: " + aJEscapedQuery.m_escapedQuery, this.getLog());
        return new AJQueryExecutor(this.getLog(), this.m_warningListener, this.m_connection, this.m_settings, this.m_catalog, aJEscapedQuery.m_escapedQuery, this.getParentStatement(), aJEscapedQuery.m_stmtType, this.m_isDirectExecute);
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        throw AJDriver.s_AJMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecute = true;
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{metadataSourceID, map, string, string2, bl});
        ArrayList<IFilter> arrayList = new ArrayList<IFilter>();
        DSIMetadataFilterFactory dSIMetadataFilterFactory = new DSIMetadataFilterFactory(true);
        dSIMetadataFilterFactory.createFilters(metadataSourceID, this.m_filterValues, this.m_escapeChar, this.m_quoteChar, bl, arrayList, map);
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new AJTypeInfoMetadataSource(this.getLog(), map, this.m_settings);
            }
            case CATALOG_SCHEMA_ONLY: {
                String string3 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                return new AJCatalogSchemaOnlyMetadataSource(this.getLog(), this.m_client, this.m_filterValues.get(0), string3);
            }
            case SCHEMA_ONLY: {
                return new AJSchemaOnlyMetadataSource(this.getLog(), this.m_client);
            }
            case CATALOG_ONLY: {
                return new AJCatalogOnlyMetadataSource(this.getLog(), this.m_client);
            }
            case COLUMNS: {
                String string4 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string5 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                return new AJColumnsMetadataSource(this.getLog(), this.m_client, arrayList, this.m_filterValues.get(0), string4, string5);
            }
            case TABLES: {
                String string6 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                return new AJTablesMetadataSource(this.getLog(), this.m_client, arrayList, this.m_filterValues.get(0), string6);
            }
            case TABLETYPE_ONLY: {
                return new DSITableTypeOnlyMetadataSource(this.getLog(), this.m_tableTypes);
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }
}

