/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.EncryptionConfiguration;
import java.util.List;

@SdkInternalApi
public class EncryptionConfigurationMarshaller {
    private static final MarshallingInfo<List> S3ENCRYPTION_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Encryption").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHENCRYPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchEncryption").build();
    private static final MarshallingInfo<StructuredPojo> JOBBOOKMARKSENCRYPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobBookmarksEncryption").build();
    private static final EncryptionConfigurationMarshaller instance = new EncryptionConfigurationMarshaller();

    public static EncryptionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionConfiguration encryptionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (encryptionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(encryptionConfiguration.getS3Encryption(), S3ENCRYPTION_BINDING);
            protocolMarshaller.marshall(encryptionConfiguration.getCloudWatchEncryption(), CLOUDWATCHENCRYPTION_BINDING);
            protocolMarshaller.marshall(encryptionConfiguration.getJobBookmarksEncryption(), JOBBOOKMARKSENCRYPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

