/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena.model.transform;

import com.simba.athena.amazonaws.services.athena.model.Column;
import com.simba.athena.amazonaws.services.athena.model.TableMetadata;
import com.simba.athena.amazonaws.services.athena.model.transform.ColumnJsonUnmarshaller;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.ListUnmarshaller;
import com.simba.athena.amazonaws.transform.MapUnmarshaller;
import com.simba.athena.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;

public class TableMetadataJsonUnmarshaller
implements Unmarshaller<TableMetadata, JsonUnmarshallerContext> {
    private static TableMetadataJsonUnmarshaller instance;

    @Override
    public TableMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableMetadata tableMetadata = new TableMetadata();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setCreateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastAccessTime", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setLastAccessTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("TableType", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setTableType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Columns", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setColumns(new ListUnmarshaller<Column>(ColumnJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("PartitionKeys", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setPartitionKeys(new ListUnmarshaller<Column>(ColumnJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    tableMetadata.setParameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return tableMetadata;
    }

    public static TableMetadataJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TableMetadataJsonUnmarshaller();
        }
        return instance;
    }
}

