/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data;

import com.dbeaver.db.oracle.model.data.spatial.SDOGeometryConverter;
import java.sql.SQLException;
import java.sql.Struct;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Geometry;

public class OracleGeometryValueHandler
extends GISGeometryValueHandler {
    public static final OracleGeometryValueHandler INSTANCE = new OracleGeometryValueHandler();
    private SDOGeometryConverter geometryConverter = new SDOGeometryConverter();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object value = resultSet.getObject(index);
        if (value == null) {
            return new DBGeometry();
        }
        if (value instanceof Struct) {
            try {
                Geometry geometry = this.geometryConverter.asGeometry((Struct)value);
                return new DBGeometry(geometry);
            }
            catch (Exception e) {
                throw new DBCException("Error converting geometry value", (Throwable)e);
            }
        }
        throw new DBCException("Unsupported geometry value: " + value);
    }
}

