/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHTunnelImpl;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationRegistry;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.net.ssh.SSHUIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class SSHTunnelConfiguratorUI
implements IObjectPropertyConfigurator<DBWHandlerConfiguration> {
    private DBWHandlerConfiguration savedConfiguration;
    private Text hostText;
    private Text portText;
    private Text userNameText;
    private Combo authMethodCombo;
    private TextWithOpen privateKeyText;
    private Label pwdLabel;
    private Text passwordText;
    private Button savePasswordCheckbox;
    private Label privateKeyLabel;
    private Combo tunnelImplCombo;
    private Text localHostText;
    private Text localPortSpinner;
    private Text remoteHostText;
    private Text remotePortSpinner;
    private Text keepAliveText;
    private Text tunnelTimeout;
    private VariablesHintLabel variablesHintLabel;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)SSHUIMessages.model_ssh_configurator_group_settings, (int)2, (int)770, (int)-1);
        UIUtils.createControlLabel((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_host_ip);
        Composite hostPortComp = UIUtils.createComposite((Composite)settingsGroup, (int)3);
        hostPortComp.setLayoutData((Object)new GridData(768));
        this.hostText = new Text(hostPortComp, 2048);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.portText = UIUtils.createLabelText((Composite)hostPortComp, (String)SSHUIMessages.model_ssh_configurator_label_port, (String)String.valueOf(22));
        this.setNumberEditStyles(this.portText);
        this.userNameText = UIUtils.createLabelText((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_user_name, null, (int)2048, (Object)new GridData(768));
        this.authMethodCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_combo_auth_method, (int)12);
        this.authMethodCombo.setLayoutData((Object)new GridData(32));
        this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_password);
        this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_pub_key);
        this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_agent);
        this.privateKeyLabel = UIUtils.createControlLabel((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_private_key);
        this.privateKeyLabel.setLayoutData((Object)new GridData(32));
        this.privateKeyText = new TextWithOpenFile((Composite)settingsGroup, SSHUIMessages.model_ssh_configurator_dialog_choose_private_key, new String[]{"*", "*.ssh", "*.pem", "*.*"});
        this.privateKeyText.setLayoutData((Object)new GridData(768));
        this.pwdLabel = UIUtils.createControlLabel((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_password);
        Composite passComp = UIUtils.createComposite((Composite)settingsGroup, (int)2);
        passComp.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(passComp, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.savePasswordCheckbox = UIUtils.createCheckbox((Composite)passComp, (String)SSHUIMessages.model_ssh_configurator_checkbox_save_pass, (boolean)false);
        this.savePasswordCheckbox.setLayoutData((Object)new GridData(32));
        Group advancedGroup = UIUtils.createControlGroup((Composite)composite, (String)SSHUIMessages.model_ssh_configurator_group_advanced, (int)4, (int)770, (int)-1);
        this.tunnelImplCombo = UIUtils.createLabelCombo((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_implementation, (int)12);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.tunnelImplCombo.setLayoutData((Object)gd);
        for (SSHImplementationDescriptor it : SSHImplementationRegistry.getInstance().getDescriptors()) {
            this.tunnelImplCombo.add(it.getLabel());
        }
        this.localHostText = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_local_host, null, (int)2048, (Object)new GridData(768));
        this.localHostText.setToolTipText(SSHUIMessages.model_ssh_configurator_label_local_host_description);
        this.localHostText.setLayoutData((Object)new GridData(768));
        this.remoteHostText = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_remote_host, null, (int)2048, (Object)new GridData(768));
        this.remoteHostText.setToolTipText(SSHUIMessages.model_ssh_configurator_label_remote_host_description);
        this.remoteHostText.setLayoutData((Object)new GridData(768));
        this.localPortSpinner = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_local_port, (String)String.valueOf(0));
        this.localPortSpinner.setToolTipText(SSHUIMessages.model_ssh_configurator_label_local_port_description);
        this.setNumberEditStyles(this.localPortSpinner);
        this.remotePortSpinner = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_remote_port, (String)String.valueOf(0));
        this.remotePortSpinner.setToolTipText(SSHUIMessages.model_ssh_configurator_label_remote_port_description);
        this.setNumberEditStyles(this.remotePortSpinner);
        UIUtils.createHorizontalLine((Composite)advancedGroup, (int)4, (int)0);
        this.keepAliveText = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_keep_alive, (String)String.valueOf(0));
        this.setNumberEditStyles(this.keepAliveText);
        this.tunnelTimeout = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_tunnel_timeout, (String)String.valueOf(10000));
        this.setNumberEditStyles(this.tunnelTimeout);
        Composite controlGroup = UIUtils.createComposite((Composite)composite, (int)2);
        controlGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)controlGroup, (String)SSHUIMessages.model_ssh_configurator_button_test_tunnel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.testTunnelConnection();
            }
        });
        String hint = "You can use variables in SSH parameters.";
        this.variablesHintLabel = new VariablesHintLabel(controlGroup, hint, hint, DataSourceDescriptor.CONNECT_VARIABLES, false);
        this.authMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.updateAuthMethodVisibility();
            }
        });
    }

    private void setNumberEditStyles(Text text) {
        text.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.ENGLISH));
        GridData gdt = new GridData(32);
        gdt.widthHint = UIUtils.getFontHeight((Control)text) * 7;
        text.setLayoutData((Object)gdt);
    }

    private void testTunnelConnection() {
        DBWHandlerConfiguration configuration = new DBWHandlerConfiguration(this.savedConfiguration);
        configuration.setProperties(Collections.emptyMap());
        this.saveSettings(configuration);
        DBPDataSourceContainer dataSource = configuration.getDataSource();
        if (dataSource != null) {
            configuration.resolveDynamicVariables((IVariableResolver)new DataSourceVariableResolver(dataSource, dataSource.getConnectionConfiguration()));
        } else {
            configuration.resolveDynamicVariables((IVariableResolver)SystemVariablesResolver.INSTANCE);
        }
        try {
            String[] tunnelVersions = new String[2];
            UIUtils.runInProgressDialog(monitor -> {
                monitor.beginTask("Instantiate SSH tunnel", 2);
                SSHTunnelImpl tunnel = new SSHTunnelImpl();
                DBPConnectionConfiguration connectionConfig = new DBPConnectionConfiguration();
                connectionConfig.setHostName("localhost");
                connectionConfig.setHostPort(configuration.getStringProperty("port"));
                try {
                    monitor.subTask("Initialize tunnel");
                    tunnel.initializeHandler(monitor, DBWorkbench.getPlatform(), configuration, connectionConfig);
                    monitor.worked(1);
                    stringArray[0] = tunnel.getImplementation().getClientVersion();
                    stringArray[1] = tunnel.getImplementation().getServerVersion();
                    monitor.subTask("Close tunnel");
                    tunnel.closeTunnel(monitor);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            });
            MessageDialog.openInformation((Shell)this.hostText.getShell(), (String)ModelMessages.dialog_connection_wizard_start_connection_monitor_success, (String)("Connected!\n\nClient version: " + tunnelVersions[0] + "\nServer version: " + tunnelVersions[1]));
        }
        catch (InvocationTargetException ex) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
        }
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        int timeoutValue;
        int kaValue;
        this.hostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("host")));
        int portString = configuration.getIntProperty("port");
        if (portString != 0) {
            this.portText.setText(String.valueOf(portString));
        } else {
            this.portText.setText(String.valueOf(22));
        }
        this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        String authTypeName = configuration.getStringProperty("authType");
        if (!CommonUtils.isEmpty((String)authTypeName)) {
            authType = SSHConstants.AuthType.valueOf((String)authTypeName);
        }
        if (SSHConstants.AuthType.PASSWORD.equals((Object)authType)) {
            this.authMethodCombo.select(0);
        } else if (SSHConstants.AuthType.PUBLIC_KEY.equals((Object)authType)) {
            this.authMethodCombo.select(1);
        } else {
            this.authMethodCombo.select(2);
        }
        this.privateKeyText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("keyPath")));
        this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
        String implType = configuration.getStringProperty("implementation");
        if (CommonUtils.isEmpty((String)implType)) {
            this.tunnelImplCombo.select(0);
        } else {
            SSHImplementationDescriptor desc = SSHImplementationRegistry.getInstance().getDescriptor(implType);
            if (desc != null) {
                this.tunnelImplCombo.setText(desc.getLabel());
            } else {
                this.tunnelImplCombo.select(0);
            }
        }
        this.localHostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("localHost")));
        int lpValue = configuration.getIntProperty("localPort");
        if (lpValue != 0) {
            this.localPortSpinner.setText(String.valueOf(lpValue));
        }
        this.remoteHostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("remoteHost")));
        int rpValue = configuration.getIntProperty("remotePort");
        if (rpValue != 0) {
            this.remotePortSpinner.setText(String.valueOf(rpValue));
        }
        if ((kaValue = configuration.getIntProperty("aliveInterval")) != 0) {
            this.keepAliveText.setText(String.valueOf(kaValue));
        }
        if ((timeoutValue = configuration.getIntProperty("sshConnectTimeout")) != 0) {
            this.tunnelTimeout.setText(String.valueOf(timeoutValue));
        }
        this.updateAuthMethodVisibility();
        this.savedConfiguration = new DBWHandlerConfiguration(configuration);
        DBPDataSourceContainer dataSource = this.savedConfiguration.getDataSource();
        if (dataSource != null) {
            this.variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver(dataSource, dataSource.getConnectionConfiguration()));
        }
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.setProperty("host", (Object)this.hostText.getText().trim());
        configuration.setProperty("port", (Object)CommonUtils.toInt((Object)this.portText.getText().trim()));
        switch (this.authMethodCombo.getSelectionIndex()) {
            case 0: {
                configuration.setProperty("authType", (Object)SSHConstants.AuthType.PASSWORD.name());
                break;
            }
            case 1: {
                configuration.setProperty("authType", (Object)SSHConstants.AuthType.PUBLIC_KEY.name());
                break;
            }
            case 2: {
                configuration.setProperty("authType", (Object)SSHConstants.AuthType.AGENT.name());
            }
        }
        configuration.setProperty("keyPath", (Object)this.privateKeyText.getText().trim());
        configuration.setUserName(this.userNameText.getText().trim());
        configuration.setPassword(this.passwordText.getText());
        configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
        String implLabel = this.tunnelImplCombo.getText();
        for (SSHImplementationDescriptor it : SSHImplementationRegistry.getInstance().getDescriptors()) {
            if (!it.getLabel().equals(implLabel)) continue;
            configuration.setProperty("implementation", (Object)it.getId());
            break;
        }
        configuration.setProperty("localHost", (Object)this.localHostText.getText().trim());
        int localPort = CommonUtils.toInt((Object)this.localPortSpinner.getText());
        if (localPort <= 0) {
            configuration.setProperty("localPort", null);
        } else {
            configuration.setProperty("localPort", (Object)localPort);
        }
        configuration.setProperty("remoteHost", (Object)this.remoteHostText.getText().trim());
        int remotePort = CommonUtils.toInt((Object)this.remotePortSpinner.getText());
        if (remotePort <= 0) {
            configuration.setProperty("remotePort", null);
        } else {
            configuration.setProperty("remotePort", (Object)remotePort);
        }
        int kaInterval = CommonUtils.toInt((Object)this.keepAliveText.getText());
        if (kaInterval <= 0) {
            configuration.setProperty("aliveInterval", null);
        } else {
            configuration.setProperty("aliveInterval", (Object)kaInterval);
        }
        int conTimeout = CommonUtils.toInt((Object)this.tunnelTimeout.getText());
        if (conTimeout != 0 && conTimeout != 10000) {
            configuration.setProperty("sshConnectTimeout", (Object)conTimeout);
        }
    }

    public void resetSettings(DBWHandlerConfiguration configuration) {
    }

    private void updateAuthMethodVisibility() {
        boolean isAgent;
        boolean isPassword = this.authMethodCombo.getSelectionIndex() == 0;
        boolean isPublicKey = this.authMethodCombo.getSelectionIndex() == 1;
        boolean bl = isAgent = this.authMethodCombo.getSelectionIndex() == 2;
        if (isPublicKey) {
            this.showPrivateKeyField(true);
            this.showPasswordField(true, SSHUIMessages.model_ssh_configurator_label_passphrase);
        } else if (isAgent) {
            this.showPrivateKeyField(false);
            this.showPasswordField(false, null);
        } else if (isPassword) {
            this.showPrivateKeyField(false);
            this.showPasswordField(true, SSHUIMessages.model_ssh_configurator_label_password);
        }
        this.hostText.getParent().getParent().getParent().layout(true, true);
    }

    private void showPasswordField(boolean show, String pwdLabelText) {
        ((GridData)this.pwdLabel.getLayoutData()).exclude = !show;
        this.pwdLabel.setVisible(show);
        Composite passComp = this.passwordText.getParent();
        ((GridData)passComp.getLayoutData()).exclude = !show;
        passComp.setVisible(show);
        if (pwdLabelText != null) {
            this.pwdLabel.setText(pwdLabelText);
        }
    }

    private void showPrivateKeyField(boolean show) {
        ((GridData)this.privateKeyLabel.getLayoutData()).exclude = !show;
        this.privateKeyLabel.setVisible(show);
        ((GridData)this.privateKeyText.getLayoutData()).exclude = !show;
        this.privateKeyText.setVisible(show);
    }

    public boolean isComplete() {
        return false;
    }
}

