/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.navigator.DBNCloudNode;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNCloudsRootNode
extends DBNNode
implements DBPHiddenObject {
    private static final Log log = Log.getLog(DBNCloudsRootNode.class);
    private DBNCloudNode[] clouds;

    DBNCloudsRootNode(DBNProject parentNode) {
        super((DBNNode)parentNode);
    }

    public String getNodeType() {
        return "clouds";
    }

    public String getNodeName() {
        return "clouds";
    }

    public String getNodeDescription() {
        return "Cloud explorer";
    }

    public DBPImage getNodeIcon() {
        return null;
    }

    protected boolean allowsChildren() {
        return true;
    }

    public DBNCloudNode[] getChildren(DBRProgressMonitor monitor) {
        if (this.clouds == null) {
            List<CloudProviderDescriptor> providers = CloudProviderRegistry.getInstance().getCloudProviders();
            ArrayList<DBNCloudNode> cloudNodes = new ArrayList<DBNCloudNode>();
            for (CloudProviderDescriptor cpDescriptor : providers) {
                CPCloud<?, ?>[] cPCloudArray = cpDescriptor.getInstance().getAvailableClouds();
                int n = cPCloudArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CPCloud<CPCloudZone, CPCloudSession<CPCloudZone>> cloud = cPCloudArray[n2];
                    cloudNodes.add(new DBNCloudNode(this, cpDescriptor, cloud));
                    ++n2;
                }
            }
            this.clouds = cloudNodes.toArray(new DBNCloudNode[0]);
        }
        return this.clouds;
    }

    public String getNodeItemPath() {
        return String.valueOf(DBNNode.NodePathType.ext.getPrefix()) + this.getNodeName();
    }

    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.refreshCloudList();
        return this;
    }

    public void refreshCloudList() {
        if (this.clouds != null) {
            DBNCloudNode[] dBNCloudNodeArray = this.clouds;
            int n = this.clouds.length;
            int n2 = 0;
            while (n2 < n) {
                DBNCloudNode node = dBNCloudNodeArray[n2];
                DBNModel.disposeNode((DBNNode)node, (boolean)true);
                ++n2;
            }
            this.clouds = null;
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public boolean isHidden() {
        return true;
    }
}

