/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudDatabaseInstanceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudNode;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseInstanceMaterialized;
import com.dbeaver.cloud.registry.CloudDatabaseServiceDescriptor;
import java.util.ArrayList;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNCloudDatabaseServiceNode
extends DBNNode
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNCloudDatabaseServiceNode.class);
    private final CloudDatabaseServiceDescriptor service;
    private DBNNode[] instanceNodes;

    DBNCloudDatabaseServiceNode(DBNCloudNode parentNode, CloudDatabaseServiceDescriptor service) {
        super((DBNNode)parentNode);
        this.service = service;
    }

    DBNCloudNode getCloudNode() {
        return (DBNCloudNode)this.getParentNode();
    }

    public String getNodeType() {
        return "databaseService";
    }

    public String getNodeName() {
        return this.service.getLabel();
    }

    public String getNodeDescription() {
        return this.service.getDescription();
    }

    public DBPImage getNodeIcon() {
        return this.service.getIcon();
    }

    protected boolean allowsChildren() {
        return true;
    }

    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.instanceNodes == null) {
            this.instanceNodes = this.readServiceInstances(monitor);
        }
        return this.instanceNodes;
    }

    public String getNodeItemPath() {
        return String.valueOf(this.getParentNode().getNodeItemPath()) + "/" + this.service.getLabel();
    }

    private DBNNode[] readServiceInstances(DBRProgressMonitor monitor) throws DBException {
        CPCloudExplorer cloudExplorer = this.getCloudNode().getCloudExplorer(monitor);
        CPDatabaseInstance[] serviceInstances = cloudExplorer.findServiceInstances(monitor, this.service.getId(), null);
        ArrayList<Object> nodes = new ArrayList<Object>();
        CPDatabaseInstance[] cPDatabaseInstanceArray = serviceInstances;
        int n = serviceInstances.length;
        int n2 = 0;
        while (n2 < n) {
            CPDatabaseInstance serviceInstance = cPDatabaseInstanceArray[n2];
            if (serviceInstance instanceof CPDatabaseInstanceMaterialized) {
                try {
                    DBPDataSourceContainer dataSourceContainer = ((CPDatabaseInstanceMaterialized)serviceInstance).createDataSourceContainer(monitor, this.getCloudNode().getDataSourceRegistry());
                    nodes.add((Object)new DBNCloudDataSourceNode(this, serviceInstance, dataSourceContainer));
                }
                catch (DBException e) {
                    log.error((Object)("Error creating datasource for database instance '" + serviceInstance.getInstanceId() + "'"), (Throwable)e);
                }
            } else {
                nodes.add((Object)new DBNCloudDatabaseInstanceNode(this, serviceInstance));
            }
            ++n2;
        }
        return nodes.toArray(new DBNNode[0]);
    }

    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        if (this.instanceNodes != null) {
            DBNNode[] dBNNodeArray = this.instanceNodes;
            int n = this.instanceNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode node = dBNNodeArray[n2];
                DBNModel.disposeNode((DBNNode)node, (boolean)true);
                ++n2;
            }
            this.instanceNodes = null;
        }
        return this;
    }

    public String toString() {
        return this.service.toString();
    }

    public boolean needsInitialization() {
        return this.instanceNodes == null;
    }
}

