/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class CPCloudUtils {
    private static final Log log = Log.getLog(CPCloudUtils.class);

    public static CPCloud<?, ?>[] getAllClouds() {
        List<CloudProviderDescriptor> providers = CloudProviderRegistry.getInstance().getCloudProviders();
        ArrayList clouds = new ArrayList();
        for (CloudProviderDescriptor cpDescriptor : providers) {
            Collections.addAll(clouds, cpDescriptor.getInstance().getAvailableClouds());
        }
        return clouds.toArray(new CPCloud[0]);
    }

    public static CPCloud<?, ?> getCloud(String cloudId) {
        List<CloudProviderDescriptor> providers = CloudProviderRegistry.getInstance().getCloudProviders();
        for (CloudProviderDescriptor cpDescriptor : providers) {
            CPCloud<?, ?>[] cPCloudArray = cpDescriptor.getInstance().getAvailableClouds();
            int n = cPCloudArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPCloud<?, ?> cloud = cPCloudArray[n2];
                if (cloud.getCloudId().equals(cloudId)) {
                    return cloud;
                }
                ++n2;
            }
        }
        return null;
    }

    public static CPCloud<?, ?> getCloud(CloudProviderDescriptor provider, String cloudId) {
        if (provider != null) {
            CPCloud<?, ?>[] cPCloudArray = provider.getInstance().getAvailableClouds();
            int n = cPCloudArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPCloud<?, ?> cloud = cPCloudArray[n2];
                if (cloud.getCloudId().equals(cloudId)) {
                    return cloud;
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T extends CPCloudConfiguration> T getCloudConfiguration(String cloudId, Class<T> configurationType) {
        CPCloud<?, ?> cloud = CPCloudUtils.getCloud(cloudId);
        if (cloud != null) {
            return (T)((CPCloudConfiguration)configurationType.cast(cloud.getCloudConfiguration()));
        }
        return null;
    }

    public static CPCloudZone findZone(CPCloud<?, ?> cloud, String zoneId) {
        CPCloudZone[] cPCloudZoneArray = cloud.getAllZones();
        int n = cPCloudZoneArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPCloudZone zone = cPCloudZoneArray[n2];
            if (zone.getZoneId().equals(zoneId)) {
                return zone;
            }
            ++n2;
        }
        return null;
    }

    public static List<DBPDataSourceContainer> createDataSourcesFromCloudNodes(@NotNull DBPProject project, @Nullable DBPDataSourceFolder folder, @NotNull List<DBNCloudDataSourceNode> nodes) throws DBException {
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
        if (projectNode == null) {
            throw new DBException("Project node '" + project.getName() + "' not found");
        }
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
        for (DBNCloudDataSourceNode dsNode : nodes) {
            DBPDataSourceContainer ds;
            DBPDataSourceContainer dataSourceContainer = dsNode.getDataSourceContainer();
            DBPDataSourceContainer newDataSource = dataSourceRegistry.createDataSource(dataSourceContainer);
            if (folder != null) {
                newDataSource.setFolder(folder);
            }
            String dsName = newDataSource.getName();
            int tryCount = 1;
            while ((ds = dataSourceRegistry.findDataSourceByName(dsName)) != null && !ds.isHidden()) {
                dsName = String.valueOf(newDataSource.getName()) + " (" + tryCount + ")";
                ++tryCount;
            }
            newDataSource.setName(dsName);
            dataSourceRegistry.addDataSource(newDataSource);
            result.add(newDataSource);
        }
        return result;
    }
}

