/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsActivator;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AbstractTextPanelEditor<EDITOR extends BaseTextEditor>
implements IStreamValueEditor<StyledText>,
IAdaptable {
    private static final String PREF_TEXT_EDITOR_WORD_WRAP = "content.text.editor.word-wrap";
    private static final String PREF_TEXT_EDITOR_AUTO_FORMAT = "content.text.editor.auto-format";
    private static final Log log = Log.getLog(AbstractTextPanelEditor.class);
    public static final int LONG_CONTENT_LENGTH = 10000;
    private IValueController valueController;
    private IEditorSite subSite;
    private EDITOR editor;
    private static IDialogSettings viewerSettings;

    @Override
    public StyledText createControl(IValueController valueController) {
        this.valueController = valueController;
        this.subSite = new SubEditorSite(valueController.getValueSite());
        this.editor = this.createEditorParty(valueController);
        try {
            this.editor.init(this.subSite, StringEditorInput.EMPTY_INPUT);
        }
        catch (PartInitException e2) {
            valueController.showMessage(e2.getMessage(), DBPMessageType.ERROR);
            return new StyledText(valueController.getEditPlaceholder(), 0);
        }
        this.editor.createPartControl(valueController.getEditPlaceholder());
        StyledText editorControl = this.editor.getEditorControl();
        assert (editorControl != null);
        this.initEditorSettings(editorControl);
        editorControl.addDisposeListener(e -> this.editor.releaseEditorInput());
        this.editor.addContextMenuContributor(manager -> this.contributeTextEditorActions(manager, editorControl));
        return editorControl;
    }

    protected abstract EDITOR createEditorParty(IValueController var1);

    protected void contributeTextEditorActions(@NotNull IContributionManager manager, @NotNull StyledText control) {
        manager.removeAll();
        Point selectionRange = control.getSelectionRange();
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.copy", selectionRange.y > 0, control, 17039369));
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.paste", control.getEditable(), control, 16908297));
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.cut", selectionRange.y > 0, control, 131199));
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.selectAll", true, control, 262209));
        manager.add((IAction)new AutoFormatAction());
        manager.add((IAction)new WordWrapAction(control));
        manager.add((IContributionItem)new Separator());
        manager.add(TextEditorUtils.createFindReplaceAction((Shell)this.editor.getSite().getShell(), (IFindReplaceTarget)this.editor.getViewer().getFindReplaceTarget()));
        IAction preferencesAction = this.editor.getAction("Preferences.ContextAction");
        if (preferencesAction != null) {
            manager.add((IContributionItem)new Separator());
            manager.add(preferencesAction);
        }
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull StyledText control) {
    }

    @Override
    public void contributeSettings(@NotNull IContributionManager manager, final @NotNull StyledText editorControl) {
        manager.add((IContributionItem)new Separator());
        Action wwAction = new Action("Word Wrap", 2){

            public void run() {
                boolean newWW = !editorControl.getWordWrap();
                this.setChecked(newWW);
                editorControl.setWordWrap(newWW);
                AbstractTextPanelEditor.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_WORD_WRAP, newWW);
            }
        };
        wwAction.setChecked(editorControl.getWordWrap());
        manager.add((IAction)wwAction);
        EDITOR textEditor = this.getTextEditor();
        if (textEditor != null) {
            AutoFormatAction afAction = new AutoFormatAction();
            afAction.setChecked(AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_AUTO_FORMAT));
            manager.add((IAction)afAction);
        }
    }

    protected EDITOR getTextEditor() {
        return this.editor;
    }

    private void initEditorSettings(StyledText control) {
        boolean wwEnabled = AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_WORD_WRAP);
        if (wwEnabled != control.getWordWrap()) {
            control.setWordWrap(wwEnabled);
        }
    }

    private void applyEditorStyle() {
        TextViewer textViewer;
        EDITOR textEditor = this.getTextEditor();
        if (textEditor != null && AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_AUTO_FORMAT) && (textViewer = textEditor.getTextViewer()) != null) {
            StyledText textWidget = textViewer.getTextWidget();
            if (textWidget == null || textWidget.isDisposed()) {
                return;
            }
            textWidget.setRedraw(false);
            boolean oldEditable = textViewer.isEditable();
            if (!oldEditable) {
                textViewer.setEditable(true);
            }
            try {
                try {
                    if (textViewer.canDoOperation(15)) {
                        textViewer.doOperation(15);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Error formatting text", (Throwable)e);
                    if (!oldEditable) {
                        textViewer.setEditable(false);
                    }
                    textWidget.setRedraw(true);
                }
            }
            finally {
                if (!oldEditable) {
                    textViewer.setEditable(false);
                }
                textWidget.setRedraw(true);
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        EDITOR textEditor = this.getTextEditor();
        if (textEditor != null) {
            TextViewer textViewer;
            if (adapter.isAssignableFrom(textEditor.getClass())) {
                return adapter.cast(textEditor);
            }
            if (adapter == IUndoManager.class && (textViewer = textEditor.getTextViewer()) != null && textViewer.getUndoManager() != null) {
                return adapter.cast(textViewer.getUndoManager());
            }
            return (T)textEditor.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        try {
            try {
                boolean longContent;
                TextViewer textViewer = this.editor.getTextViewer();
                ContentEditorInput textInput = new ContentEditorInput(this.valueController, null, null, monitor);
                boolean bl = longContent = textInput.getContentLength() > 10000L;
                if (longContent) {
                    UIUtils.asyncExec(() -> this.editor.setInput((IEditorInput)new StringEditorInput("Empty", (CharSequence)"", true, StandardCharsets.UTF_8.name())));
                }
                UIUtils.asyncExec(() -> {
                    if (textViewer != null) {
                        StyledText textWidget = textViewer.getTextWidget();
                        if (textWidget != null && longContent) {
                            GC gc = new GC((Drawable)textWidget);
                            try {
                                UIUtils.drawMessageOverControl((Control)textWidget, (GC)gc, (String)("Loading content ... (" + textInput.getContentLength() + ")"), (int)0);
                                this.editor.setInput((IEditorInput)textInput);
                            }
                            finally {
                                gc.dispose();
                            }
                        } else {
                            this.editor.setInput((IEditorInput)textInput);
                        }
                        this.applyEditorStyle();
                    }
                });
            }
            catch (Exception e) {
                throw new DBException("Error loading text value", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        if (this.valueController.getValue() instanceof DBDContent) {
            monitor.beginTask("Extract text", 1);
            try {
                try {
                    monitor.subTask("Extracting text from editor");
                    this.editor.doSave(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                    IEditorInput editorInput = this.editor.getEditorInput();
                    if (!(editorInput instanceof ContentEditorInput)) return;
                    ContentEditorInput contentEditorInput = (ContentEditorInput)editorInput;
                    contentEditorInput.updateContentFromFile(monitor, value);
                    return;
                }
                catch (Exception e) {
                    throw new DBException("Error extracting text from editor", (Throwable)e);
                }
            }
            finally {
                monitor.done();
            }
        } else {
            value.updateContents(monitor, (DBDContentStorage)new StringContentStorage(control.getText()));
        }
    }

    public static IDialogSettings getPanelSettings() {
        if (viewerSettings == null) {
            viewerSettings = UIUtils.getSettingsSection((IDialogSettings)DataEditorsActivator.getDefault().getDialogSettings(), (String)AbstractTextPanelEditor.class.getSimpleName());
        }
        return viewerSettings;
    }

    private class AutoFormatAction
    extends Action {
        AutoFormatAction() {
            super("Auto Format", 2);
        }

        public boolean isChecked() {
            return AbstractTextPanelEditor.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT);
        }

        public void run() {
            boolean newAF = !AbstractTextPanelEditor.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT);
            AbstractTextPanelEditor.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT, newAF);
            AbstractTextPanelEditor.this.applyEditorStyle();
        }
    }

    private class WordWrapAction
    extends StyledTextUtils.StyledTextActionEx {
        private final StyledText text;

        WordWrapAction(StyledText text) {
            super("org.eclipse.ui.edit.text.toggleWordWrap", 2);
            this.text = text;
        }

        public boolean isChecked() {
            return this.text.getWordWrap();
        }

        public void run() {
            this.text.setWordWrap(!this.text.getWordWrap());
        }
    }
}

