/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelectionExt;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

class ResultSetStatListener
extends ResultSetListenerAdapter {
    private final ResultSetViewer viewer;
    private SLUpdateJob updateJob;

    ResultSetStatListener(ResultSetViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        this.viewer.getSelection();
        IWorkbenchPartSite site = this.viewer.getSite();
        if (site instanceof IEditorSite) {
            if (this.updateJob == null) {
                this.updateJob = new SLUpdateJob();
            }
            this.updateJob.schedule(100L);
        }
    }

    class SLUpdateJob
    extends UIJob {
        SLUpdateJob() {
            super("Update status line");
            this.setSystem(true);
            this.setUser(false);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IResultSetSelection selection = ResultSetStatListener.this.viewer.getSelection();
            if (selection instanceof IResultSetSelectionExt) {
                IResultSetSelectionExt selectionExt = (IResultSetSelectionExt)selection;
                DBPPreferenceStore preferenceStore = ResultSetStatListener.this.viewer.getPreferenceStore();
                String slText = "";
                if (preferenceStore.getBoolean("resultset.show.selected.rows")) {
                    slText = "Rows: " + selectionExt.getSelectedRowCount();
                }
                if (preferenceStore.getBoolean("resultset.show.selected.columns")) {
                    if (!slText.isEmpty()) {
                        slText = String.valueOf(slText) + ", ";
                    }
                    slText = String.valueOf(slText) + "Cols: " + selectionExt.getSelectedColumnCount();
                }
                if (preferenceStore.getBoolean("resultset.show.selected.cells")) {
                    if (!slText.isEmpty()) {
                        slText = String.valueOf(slText) + ", ";
                    }
                    slText = String.valueOf(slText) + "Cells: " + selectionExt.getSelectedCellCount();
                }
                ResultSetStatListener.this.viewer.setSelectionStatistics(slText);
            }
            return Status.OK_STATUS;
        }
    }
}

