/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.ui.contentassist.StyledTextContentAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

public class ResultSetFilterContentAdapter
extends StyledTextContentAdapter {
    private final ResultSetViewer viewer;

    public ResultSetFilterContentAdapter(ResultSetViewer viewer) {
        this.viewer = viewer;
    }

    public void insertControlContents(Control control, String contents, int cursorPosition) {
        StyledText text = (StyledText)control;
        String curValue = text.getText().toUpperCase();
        Point selection = text.getSelection();
        if (selection.x == selection.y) {
            String contentsUC = contents.toUpperCase().trim();
            DBPDataSource dataSource = this.viewer.getDataSource();
            if (dataSource != null) {
                contentsUC = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)contentsUC);
            }
            int i = selection.x - 1;
            while (i >= 0) {
                String prefix = curValue.substring(i, selection.x);
                if (contentsUC.startsWith(prefix) && (i == 0 || !Character.isJavaIdentifierPart(curValue.charAt(i - 1)))) {
                    text.setSelection(i, selection.x);
                    break;
                }
                char ch = Character.toUpperCase(curValue.charAt(i));
                if (!Character.isLetterOrDigit(ch) && contentsUC.indexOf(ch) == -1) break;
                --i;
            }
        }
        text.insert(contents);
        if (cursorPosition <= contents.length()) {
            text.setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
    }
}

