/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

class DataFilterRegistry {
    private static final Log log = Log.getLog(DataFilterRegistry.class);
    private static final String CONFIG_FILE = "saved-data-filter.xml";
    private static final String OBJ_PATH_DELIMITER = "@@/@@";
    private static DataFilterRegistry instance;
    private final Map<String, SavedDataFilter> savedFilters = new HashMap<String, SavedDataFilter>();
    private volatile ConfigSaver saver = null;

    public static synchronized DataFilterRegistry getInstance() {
        if (instance == null) {
            instance = new DataFilterRegistry();
        }
        return instance;
    }

    public DataFilterRegistry() {
        File columnsConfig = DBWorkbench.getPlatform().getConfigurationFile(CONFIG_FILE);
        if (columnsConfig.exists()) {
            this.loadConfiguration(columnsConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SavedDataFilter getSavedConfig(DBSDataContainer object) {
        String objectId = DataFilterRegistry.makeObjectId((DBSObject)object);
        Map<String, SavedDataFilter> map = this.savedFilters;
        synchronized (map) {
            return this.savedFilters.get(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDataFilter(DBSDataContainer object, DBDDataFilter dataFilter) {
        String objectId = DataFilterRegistry.makeObjectId((DBSObject)object);
        Map<String, SavedDataFilter> map = this.savedFilters;
        synchronized (map) {
            if (dataFilter.isDirty()) {
                SavedDataFilter newStates = new SavedDataFilter(object.getDataSource(), dataFilter);
                this.savedFilters.put(objectId, newStates);
            } else {
                this.savedFilters.remove(objectId);
            }
            if (this.saver == null) {
                this.saver = new ConfigSaver();
                this.saver.schedule(3000L);
            }
        }
    }

    public static String makeObjectId(DBSObject object) {
        DBSObject[] path = DBUtils.getObjectPath((DBSObject)object, (boolean)true);
        StringBuilder objName = new StringBuilder();
        DBSObject[] dBSObjectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject p = dBSObjectArray[n2];
            if (objName.length() > 0) {
                objName.append(OBJ_PATH_DELIMITER);
            }
            objName.append(p.getName());
            ++n2;
        }
        return objName.toString();
    }

    private void loadConfiguration(File configFile) {
        this.savedFilters.clear();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(configFile);){
                SAXReader parser = new SAXReader((InputStream)in);
                DataFilterParser dsp = new DataFilterParser();
                parser.parse((SAXListener)dsp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading data filters config", (Throwable)e);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Data filters config save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            Map map = DataFilterRegistry.this.savedFilters;
            synchronized (map) {
                this.flushConfig();
                DataFilterRegistry.this.saver = null;
            }
            return Status.OK_STATUS;
        }

        private void flushConfig() {
            File configFile = DBWorkbench.getPlatform().getConfigurationFile(DataFilterRegistry.CONFIG_FILE);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream out = new FileOutputStream(configFile);){
                    XMLBuilder xml = new XMLBuilder((OutputStream)out, GeneralUtils.UTF8_ENCODING);
                    xml.setButify(true);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (XMLBuilder.Element e = xml.startElement("data-filters");){
                        for (Map.Entry entry : DataFilterRegistry.this.savedFilters.entrySet()) {
                            Throwable throwable3 = null;
                            Object var12_18 = null;
                            try (XMLBuilder.Element e2 = xml.startElement("filter");){
                                xml.addAttribute("objectId", (String)entry.getKey());
                                SavedDataFilter sdf = (SavedDataFilter)entry.getValue();
                                xml.addAttribute("anyConstraint", sdf.anyConstraint);
                                if (!CommonUtils.isEmpty((String)sdf.order)) {
                                    xml.addAttribute("order", sdf.order);
                                }
                                if (!CommonUtils.isEmpty((String)sdf.where)) {
                                    xml.addAttribute("where", sdf.where);
                                }
                                for (Map.Entry attrCE : sdf.constraints.entrySet()) {
                                    Throwable throwable4 = null;
                                    Object var18_26 = null;
                                    try (XMLBuilder.Element e3 = xml.startElement("constraint");){
                                        Object[] options;
                                        xml.addAttribute("name", (String)attrCE.getKey());
                                        DBDAttributeConstraintBase attrC = (DBDAttributeConstraintBase)attrCE.getValue();
                                        if (!attrC.isVisible()) {
                                            xml.addAttribute("visible", false);
                                        }
                                        xml.addAttribute("pos", attrC.getVisualPosition());
                                        if (attrC.getOrderPosition() > 0) {
                                            xml.addAttribute("order", attrC.getOrderPosition());
                                            xml.addAttribute("orderDesc", attrC.isOrderDescending());
                                        }
                                        if (!CommonUtils.isEmpty((String)attrC.getCriteria())) {
                                            xml.addAttribute("criteria", attrC.getCriteria());
                                        }
                                        if (attrC.getOperator() != null) {
                                            xml.addAttribute("operator", attrC.getOperator().name());
                                        }
                                        if (!CommonUtils.isEmpty((String)attrC.getEntityAlias())) {
                                            xml.addAttribute("entity", attrC.getEntityAlias());
                                        }
                                        if (attrC.getValue() != null) {
                                            xml.startElement("value");
                                            xml.addText((CharSequence)GeneralUtils.serializeObject((Object)attrC.getValue()));
                                            xml.endElement();
                                        }
                                        if (ArrayUtils.isEmpty((Object[])(options = attrC.getOptions()))) continue;
                                        int i = 0;
                                        while (i < options.length) {
                                            xml.startElement("option");
                                            xml.addAttribute("name", CommonUtils.toString((Object)options[i]));
                                            xml.addText((CharSequence)GeneralUtils.serializeObject((Object)options[i + 1]));
                                            xml.endElement();
                                            i += 2;
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable4 == null) {
                                            throwable4 = throwable5;
                                        } else if (throwable4 != throwable5) {
                                            throwable4.addSuppressed(throwable5);
                                        }
                                        throw throwable4;
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable3 == null) {
                                    throwable3 = throwable6;
                                } else if (throwable3 != throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                    xml.flush();
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving columns configuration", (Throwable)e);
            }
        }
    }

    private class DataFilterParser
    extends SAXListener.BaseListener {
        private SavedDataFilter curSavedDataFilter = null;
        private DBDAttributeConstraintBase curSavedConstraint = null;
        private boolean isInValue = false;
        private String curOptionName = null;

        private DataFilterParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            switch (localName) {
                case "filter": {
                    this.curSavedDataFilter = new SavedDataFilter();
                    this.curSavedDataFilter.anyConstraint = CommonUtils.toBoolean((Object)atts.getValue("anyConstraint"));
                    String objectId = atts.getValue("objectId");
                    DataFilterRegistry.this.savedFilters.put(objectId, this.curSavedDataFilter);
                    break;
                }
                case "constraint": {
                    if (this.curSavedDataFilter == null) break;
                    this.curSavedConstraint = new DBDAttributeConstraintBase();
                    String name = atts.getValue("name");
                    this.curSavedConstraint.setVisualPosition(CommonUtils.toInt((Object)atts.getValue("pos")));
                    if (atts.getValue("order") != null) {
                        this.curSavedConstraint.setOrderPosition(CommonUtils.toInt((Object)atts.getValue("order")));
                        this.curSavedConstraint.setOrderDescending(CommonUtils.toBoolean((Object)atts.getValue("orderDesc")));
                    }
                    this.curSavedConstraint.setCriteria(atts.getValue("criteria"));
                    this.curSavedConstraint.setVisible(CommonUtils.getBoolean((String)atts.getValue("visible"), (boolean)true));
                    String operName = atts.getValue("operator");
                    if (!CommonUtils.isEmpty((String)operName)) {
                        try {
                            this.curSavedConstraint.setOperator(DBCLogicalOperator.valueOf((String)operName));
                        }
                        catch (IllegalArgumentException e) {
                            log.error((Object)e);
                        }
                    }
                    this.curSavedConstraint.setEntityAlias(atts.getValue("entity"));
                    this.curSavedDataFilter.constraints.put(name, this.curSavedConstraint);
                    break;
                }
                case "value": {
                    if (this.curSavedConstraint == null) break;
                    this.isInValue = true;
                    break;
                }
                case "option": {
                    if (this.curSavedConstraint == null) break;
                    this.curOptionName = CommonUtils.toString((Object)atts.getValue("name"));
                }
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
            switch (localName) {
                case "filter": {
                    this.curSavedDataFilter = null;
                    break;
                }
                case "constraint": {
                    this.curSavedConstraint = null;
                    break;
                }
                case "value": {
                    this.isInValue = false;
                    break;
                }
                case "option": {
                    this.curOptionName = null;
                }
            }
        }

        public void saxText(SAXReader reader, String data) throws XMLException {
            if (this.isInValue) {
                this.curSavedConstraint.setValue(GeneralUtils.deserializeObject((String)data));
            } else if (this.curOptionName != null) {
                this.curSavedConstraint.setOption(this.curOptionName, GeneralUtils.deserializeObject((String)data));
                this.curSavedConstraint.setOption(this.curOptionName, GeneralUtils.deserializeObject((String)data));
            }
        }
    }

    public static class SavedDataFilter {
        private Map<String, DBDAttributeConstraintBase> constraints = new LinkedHashMap<String, DBDAttributeConstraintBase>();
        private boolean anyConstraint;
        private String order;
        private String where;

        SavedDataFilter() {
        }

        SavedDataFilter(DBPDataSource dataSource, DBDDataFilter dataFilter) {
            for (DBDAttributeConstraint c : dataFilter.getConstraints()) {
                if (c.getAttribute() == null) continue;
                this.constraints.put(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)c.getAttribute().getName()), (DBDAttributeConstraintBase)new DBDAttributeConstraint(c));
            }
            this.anyConstraint = dataFilter.isAnyConstraint();
            this.order = dataFilter.getOrder();
            this.where = dataFilter.getWhere();
        }

        void restoreDataFilter(DBRProgressMonitor monitor, DBSDataContainer dataContainer, DBDDataFilter dataFilter) throws DBException {
            dataFilter.setAnyConstraint(this.anyConstraint);
            dataFilter.setOrder(this.order);
            dataFilter.setWhere(this.where);
            for (Map.Entry<String, DBDAttributeConstraintBase> savedC : this.constraints.entrySet()) {
                DBSEntityAttribute attribute;
                DBDAttributeConstraint attrC;
                String attrName = savedC.getKey();
                if (dataContainer.getDataSource() != null) {
                    attrName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataContainer.getDataSource(), (String)attrName);
                }
                if ((attrC = dataFilter.getConstraint(attrName)) == null && dataContainer instanceof DBSEntity && (attribute = ((DBSEntity)dataContainer).getAttribute(monitor, attrName)) != null) {
                    attrC = new DBDAttributeConstraint((DBSAttributeBase)attribute, attribute.getOrdinalPosition());
                    dataFilter.addConstraints(Collections.singletonList(attrC));
                }
                if (attrC == null) continue;
                attrC.copyFrom(savedC.getValue());
            }
        }
    }
}

