/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.parser;

class Quote {
    public static final int QUOTE_NONE = 1;
    public static final int QUOTE_SINGLE = 2;
    public static final int QUOTE_EXTENDED = 4;
    public static final int QUOTE_UNICODE = 8;
    public static final int QUOTE_DOLLAR = 16;
    public static final int QUOTE_DOUBLE = 32;
    public static final Quote NO_QUOTES = new Quote();
    public static final Quote SINGLE_QUOTES;
    public static final Quote EXTENDED_QUOTES;
    public static final Quote UNICODE_QUOTES;
    public static final Quote DOUBLE_QUOTES;
    public String tag;
    public int type;
    public char closing;

    Quote() {
    }

    public void setType(int n) {
        this.type = n;
        switch (this.type) {
            case 1: {
                this.closing = '\u0000';
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                this.closing = (char)39;
                break;
            }
            case 32: {
                this.closing = (char)34;
                break;
            }
            case 16: {
                this.closing = (char)36;
                break;
            }
            default: {
                throw new ClassCastException("There is no quote type as " + n);
            }
        }
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "";
            }
            case 2: {
                return "'";
            }
            case 4: {
                return "E'";
            }
            case 32: {
                return "\"";
            }
            case 8: {
                return "U&'";
            }
            case 16: {
                return "$" + (this.tag == null ? "" : this.tag) + "$";
            }
        }
        return "";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Quote) {
            boolean bl;
            Quote quote = (Quote)object;
            boolean bl2 = bl = quote.type == this.type;
            if (this.type == 16) {
                bl = this.tag != null ? (bl |= this.tag.equals(quote.tag)) : (bl |= quote.tag == null);
            }
            return bl;
        }
        return super.equals(object);
    }

    static {
        NO_QUOTES.setType(1);
        SINGLE_QUOTES = new Quote();
        SINGLE_QUOTES.setType(2);
        EXTENDED_QUOTES = new Quote();
        EXTENDED_QUOTES.setType(4);
        UNICODE_QUOTES = new Quote();
        UNICODE_QUOTES.setType(8);
        DOUBLE_QUOTES = new Quote();
        DOUBLE_QUOTES.setType(32);
    }
}

