/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSIEmptyResultSet;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.jdbc4.S4ForwardResultSet;
import com.vertica.jdbc.jdbc4.S4ParameterMetaData;
import com.vertica.jdbc.jdbc4.S4ResultSetMetaData;
import com.vertica.jdbc.jdbc4.S4UpdatableForwardResultSet;
import com.vertica.jdbc.jdbc4.utilities.WrapperUtilities;
import com.vertica.streams.IStream;
import com.vertica.streams.parameters.AsciiParameterStream;
import com.vertica.streams.parameters.BinaryParameterStream;
import com.vertica.streams.parameters.CharacterParameterStream;
import com.vertica.streams.parametersoutput.CharacterParameterDataStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S4CallableStatement
extends SCallableStatement {
    private IStream m_currentStream = null;

    public S4CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC4;
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S4UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger()) : new S4ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger());
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            S4ForwardResultSet s4ForwardResultSet = null;
            s4ForwardResultSet = new S4ForwardResultSet(this, new DSIEmptyResultSet(), this.getLogger());
            return s4ForwardResultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                ExecutionResults executionResults = this.getQueryExecutor().getResults();
                ArrayList<ExecutionResult> arrayList = executionResults.getResults();
                if (arrayList.isEmpty()) {
                    return null;
                }
                if (1 != arrayList.size()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
                }
                ExecutionResult executionResult = (ExecutionResult)arrayList.get(0);
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    ArrayList<? extends IColumn> arrayList2 = iResultSet.getSelectColumns();
                    if (null == arrayList2) {
                        return null;
                    }
                    S4ResultSetMetaData s4ResultSetMetaData = null;
                    s4ResultSetMetaData = new S4ResultSetMetaData(arrayList2, this.getLogger(), this.getWarningListener());
                    this.setResultSetMetadata(s4ResultSetMetaData);
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S4ParameterMetaData s4ParameterMetaData = null;
                s4ParameterMetaData = new S4ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s4ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                if (dataWrapper.isNull()) {
                    return null;
                }
                CharacterParameterDataStream characterParameterDataStream = new CharacterParameterDataStream(dataWrapper.getLongVarChar().getBytes("UTF-16"));
                this.m_currentStream = characterParameterDataStream;
                return characterParameterDataStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "CharacterStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public NClob getNClob(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNClob(this.getParameterIndex(string));
    }

    @Override
    public String getNString(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public String getNString(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNString(this.getParameterIndex(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public RowId getRowId(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getRowId(this.getParameterIndex(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getSQLXML(this.getParameterIndex(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setAsciiStream(n, inputStream, -1);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.getWarningListener(), ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, (int)typeMetadata.getType());
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, l, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setBinaryStream(n, inputStream, -1);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-4, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.getWarningListener(), ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, (int)typeMetadata.getType());
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, l, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBinaryStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, blob);
        this.setBlob(this.getParameterIndex(string), blob);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBlob(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, l);
        this.setBlob(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.setCharacterStream(n, reader, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.getWarningListener(), ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == reader) {
                this.setNull(n, (int)typeMetadata.getType());
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, l, parameterMetadata, (int)typeMetadata.getType());
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clob);
        this.checkIfOpen();
        this.getParameterIndex(string);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setClob(this.getParameterIndex(string), reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setNCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setNCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, nClob);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, nClob);
        this.setNClob(this.getParameterIndex(string), nClob);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setNClob(this.getParameterIndex(string), reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setNClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, string);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNString(String string, String string2) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
        this.setNString(this.getParameterIndex(string), string2);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, rowId);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, rowId);
        this.setRowId(this.getParameterIndex(string), rowId);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, sQLXML);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLXML);
        this.setSQLXML(this.getParameterIndex(string), sQLXML);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    private void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }
}

