/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataColumn;
import com.vertica.dsi.dataengine.utilities.MetadataColumnFactory;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSIMetadataResultSet
implements IResultSet {
    protected ILogger m_logger;
    private IMetadataSource m_metadataSource;
    private List<IFilter> m_filters;
    protected List<MetadataColumn> m_columns;
    protected List<MetadataSourceColumnTag> m_sortOrder;
    private IWarningListener m_warningListener = null;
    private boolean m_performFiltering = true;
    protected List<MetadataRow> m_rows = null;
    private int m_currentRowIndex = -1;
    protected final OrderType m_orderType;
    protected final boolean m_isODBC2;

    public DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType) throws ErrorException {
        this(iStatement, metadataSourceID, iMetadataSource, list, orderType, false);
    }

    public DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), new Object[]{iStatement, metadataSourceID, iMetadataSource, list});
        this.m_logger = iStatement.getLog();
        this.m_filters = list;
        this.m_metadataSource = iMetadataSource;
        this.m_orderType = orderType;
        this.m_isODBC2 = bl;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(iStatement, metadataSourceID);
        this.m_sortOrder = MetadataColumnFactory.getSortOrder(iStatement.getLog(), metadataSourceID, list, orderType);
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == variant.getLong();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
        }
        if (OrderType.NONE != orderType) {
            try {
                this.sortData();
            }
            catch (Exception exception) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.SORTING_ERROR.name(), exception);
            }
        } else {
            this.initializeRows();
        }
    }

    protected DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, List<IFilter> list, OrderType orderType) throws ErrorException {
        this(iStatement, metadataSourceID, list, orderType, false);
    }

    protected DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, List<IFilter> list, OrderType orderType, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), new Object[]{iStatement, metadataSourceID, list});
        this.m_logger = iStatement.getLog();
        this.m_filters = list;
        this.m_orderType = orderType;
        this.m_isODBC2 = bl;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(iStatement, metadataSourceID);
        this.m_sortOrder = MetadataColumnFactory.getSortOrder(iStatement.getLog(), metadataSourceID, list, orderType);
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == variant.getLong();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
        }
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_metadataSource) {
            this.m_metadataSource.close();
            this.m_metadataSource = null;
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_metadataSource) {
            this.m_metadataSource.closeCursor();
        }
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        DataWrapper dataWrapper2 = (DataWrapper)this.m_rows.get(this.m_currentRowIndex).m_rowData.get(n);
        try {
            if (null != dataWrapper2.getObject()) {
                dataWrapper.setData(dataWrapper2.getType(), dataWrapper2.getObject());
            } else {
                dataWrapper.setNull(dataWrapper2.getType());
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(dataWrapper2.getType()), dataWrapper2.getObject().getClass().getName()});
        }
        return false;
    }

    @Override
    public int getFetchSize() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return 0;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return -1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return (ArrayList)this.m_columns;
    }

    public List<MetadataSourceColumnTag> getSortOrder() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_sortOrder;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentRowIndex < this.m_rows.size();
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return ++this.m_currentRowIndex < this.m_rows.size();
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{cursorType});
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType), ExceptionType.DEFAULT);
        }
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    protected boolean getUnsortedData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        if (n >= this.m_columns.size()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), String.valueOf(n), ExceptionType.DATA);
        }
        if (this.m_columns.get(n).isNullColumn()) {
            dataWrapper.setNull(this.m_columns.get(n).getTypeMetadata().getType());
            return false;
        }
        MetadataSourceColumnTag metadataSourceColumnTag = this.m_columns.get(n).getColumnTag();
        boolean bl = this.m_metadataSource.getMetadata(metadataSourceColumnTag, l, l2, dataWrapper);
        if (this.m_isODBC2 && MetadataSourceColumnTag.DATA_TYPE == metadataSourceColumnTag) {
            int n2 = 0;
            try {
                n2 = dataWrapper.getSmallInt();
            }
            catch (IncorrectTypeException incorrectTypeException) {
                // empty catch block
            }
            switch (n2) {
                case 91: {
                    dataWrapper.setSmallInt(9);
                    break;
                }
                case 92: {
                    dataWrapper.setSmallInt(10);
                    break;
                }
                case 93: {
                    dataWrapper.setSmallInt(11);
                }
            }
        }
        return bl;
    }

    protected boolean hasMoreUnsortedRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_metadataSource.hasMoreRows();
    }

    protected void initializeRows() throws ErrorException {
        Object object;
        int n;
        Pair[] pairArray = new Pair[this.m_sortOrder.size()];
        for (int i = 0; i < this.m_sortOrder.size(); ++i) {
            for (n = 0; n < this.m_columns.size(); ++n) {
                object = this.m_columns.get(n).getColumnTag();
                if (object != this.m_sortOrder.get(i)) continue;
                pairArray[i] = new Pair<Integer, MetadataSourceColumnTag>(n, (MetadataSourceColumnTag)((Object)object));
            }
        }
        if (null == this.m_rows) {
            this.m_rows = new ArrayList<MetadataRow>();
        }
        while (this.moveToNextUnsortedRow()) {
            ArrayList<DataWrapper> arrayList = new ArrayList<DataWrapper>(this.m_columns.size());
            for (n = 0; n < this.m_columns.size(); ++n) {
                object = new DataWrapper();
                try {
                    this.getUnsortedData(n, 0L, -1L, (DataWrapper)object);
                }
                catch (ErrorException errorException) {
                    if (this.m_columns.get(n).getColumnTag() == MetadataSourceColumnTag.USER_DATA_TYPE) {
                        LogUtilities.logError(errorException, this.m_logger);
                    }
                    throw errorException;
                }
                arrayList.add((DataWrapper)object);
            }
            this.m_rows.add(new MetadataRow(pairArray, arrayList, this.m_orderType));
        }
    }

    protected boolean moveToNextUnsortedRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_performFiltering) {
            return this.m_metadataSource.moveToNextRow();
        }
        while (this.m_metadataSource.moveToNextRow()) {
            if (!this.checkRow()) continue;
            return true;
        }
        return false;
    }

    protected void sortData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.initializeRows();
        Collections.sort(this.m_rows);
    }

    private boolean checkRow() throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        for (IFilter iFilter : this.m_filters) {
            this.m_metadataSource.getMetadata(iFilter.getColumnTag(), 0L, -1L, dataWrapper);
            if (iFilter.filter(dataWrapper)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MetadataRow
    implements Comparable<MetadataRow> {
        private final Pair<Integer, MetadataSourceColumnTag>[] m_columnsSortIndex;
        private final List<DataWrapper> m_rowData;
        private final OrderType m_orderType;

        public MetadataRow(Pair<Integer, MetadataSourceColumnTag>[] pairArray, List<DataWrapper> list, OrderType orderType) {
            this.m_columnsSortIndex = pairArray;
            this.m_rowData = list;
            this.m_orderType = orderType;
        }

        @Override
        public int compareTo(MetadataRow metadataRow) {
            for (Pair<Integer, MetadataSourceColumnTag> pair : this.m_columnsSortIndex) {
                DataWrapper dataWrapper = metadataRow.m_rowData.get(pair.key());
                DataWrapper dataWrapper2 = this.m_rowData.get(pair.key());
                if (dataWrapper.getType() != dataWrapper2.getType()) {
                    throw new ClassCastException("Unable to compare rows. Data type mismatch.");
                }
                int n = this.doCompareTo(dataWrapper2, dataWrapper, pair.value());
                if (0 == n) continue;
                return n;
            }
            return 0;
        }

        private int doCompareTo(DataWrapper dataWrapper, DataWrapper dataWrapper2, MetadataSourceColumnTag metadataSourceColumnTag) {
            try {
                boolean bl;
                boolean bl2 = null == dataWrapper.getObject();
                boolean bl3 = bl = null == dataWrapper2.getObject();
                if (bl2 || bl) {
                    if (bl2 && bl) {
                        return 0;
                    }
                    if (bl2) {
                        return -1;
                    }
                    return 1;
                }
                if (metadataSourceColumnTag == MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE) {
                    return this.compareProcedureColumnType(dataWrapper.getSmallInt(), dataWrapper2.getSmallInt());
                }
                if (TypeUtilities.isIntegerType(dataWrapper.getType())) {
                    Long l = this.getIntegerValue(dataWrapper);
                    Long l2 = this.getIntegerValue(dataWrapper2);
                    if (metadataSourceColumnTag == MetadataSourceColumnTag.DATA_TYPE && OrderType.ODBC != this.m_orderType) {
                        l = TypeUtilities.mapDataTypes(l.intValue());
                        l2 = TypeUtilities.mapDataTypes(l2.intValue());
                    }
                    return l.compareTo(l2);
                }
                return this.getStringValue(dataWrapper).compareTo(this.getStringValue(dataWrapper2));
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new ClassCastException(incorrectTypeException.getMessage());
            }
        }

        private int compareProcedureColumnType(int n, int n2) {
            if (n == n2 || this.isParameterTypeOrdinalEquivalent(n, n2)) {
                return 0;
            }
            if (ParameterType.RETURN_VALUE.ordinal() == n) {
                return -1;
            }
            if (ParameterType.RETURN_VALUE.ordinal() == n2) {
                return 1;
            }
            if (ParameterType.INPUT.ordinal() == n || ParameterType.OUTPUT.ordinal() == n || ParameterType.INPUT_OUTPUT.ordinal() == n) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataWrapper dataWrapper : this.m_rowData) {
                if (null != dataWrapper.getObject()) {
                    stringBuilder.append(dataWrapper.getObject().toString());
                } else {
                    stringBuilder.append("null");
                }
                stringBuilder.append("-");
            }
            return stringBuilder.toString();
        }

        private Long getIntegerValue(DataWrapper dataWrapper) throws IncorrectTypeException {
            int n = dataWrapper.getType();
            if (-6 == n) {
                return (long)dataWrapper.getTinyInt();
            }
            if (5 == n) {
                return (long)dataWrapper.getSmallInt();
            }
            if (4 == n) {
                return dataWrapper.getInteger();
            }
            return null;
        }

        private String getStringValue(DataWrapper dataWrapper) throws IncorrectTypeException {
            switch (dataWrapper.getType()) {
                case -8: 
                case 1: {
                    return dataWrapper.getChar();
                }
                case -9: 
                case 12: {
                    return dataWrapper.getVarChar();
                }
                case -10: 
                case -1: {
                    return dataWrapper.getLongVarChar();
                }
            }
            return null;
        }

        private boolean isParameterTypeOrdinalEquivalent(int n, int n2) {
            return !(ParameterType.INPUT.ordinal() != n && ParameterType.OUTPUT.ordinal() != n && ParameterType.INPUT_OUTPUT.ordinal() != n || ParameterType.INPUT.ordinal() != n2 && ParameterType.OUTPUT.ordinal() != n2 && ParameterType.INPUT_OUTPUT.ordinal() != n2);
        }
    }
}

