/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.Date;
import java.util.Map;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Value;

public class Record {
    private final Map<String, Value> valueMap;
    private final boolean deleted;

    public Record(Map<String, Value> valueMap) {
        this(false, valueMap);
    }

    Record(boolean deleted, Map<String, Value> valueMap) {
        this.deleted = deleted;
        this.valueMap = valueMap;
    }

    public byte[] getRawValue(Field field) throws DbfLibException {
        Value v = this.valueMap.get(field.getName());
        if (v == null) {
            return null;
        }
        return v.getRawValue(field);
    }

    public Object getTypedValue(String fieldName) {
        Value v = this.valueMap.get(fieldName);
        if (v == null) {
            return null;
        }
        return v.getTypedValue();
    }

    public Number getNumberValue(String fieldName) {
        return (Number)this.getTypedValue(fieldName);
    }

    public String getStringValue(String fieldName) {
        return (String)this.getTypedValue(fieldName);
    }

    public Boolean getBooleanValue(String fieldName) {
        return (Boolean)this.getTypedValue(fieldName);
    }

    public Date getDateValue(String fieldName) {
        return (Date)this.getTypedValue(fieldName);
    }

    public boolean isMarkedDeleted() {
        return this.deleted;
    }
}

