/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.Date;
import java.util.regex.Pattern;
import nl.knaw.dans.common.dbflib.AbstractDataValidator;
import nl.knaw.dans.common.dbflib.DataMismatchException;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Type;

class DateFormatValidator
extends AbstractDataValidator {
    private final Pattern datePattern = Pattern.compile("\\d{8,8}");

    DateFormatValidator(Field field) {
        super(field);
        assert (field.getType() == Type.DATE) : "Can only be validator for DATE fields";
    }

    @Override
    public void validate(Object typedObject) throws DbfLibException {
        if (typedObject instanceof Date) {
            return;
        }
        if (typedObject instanceof String) {
            String dateString = (String)typedObject;
            if (!this.datePattern.matcher(dateString).matches()) {
                throw new DataMismatchException("'" + typedObject + " is not in the correct date format for DBF (YYYYMMDD)");
            }
            return;
        }
        throw new DataMismatchException("Cannot write objects of type '" + typedObject.getClass().getName() + "' to a DATE field");
    }
}

