/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.util;

import com.dbeaver.model.sql.plan.emf.SQLPlan;
import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import com.dbeaver.ui.editors.sql.plan.diagram.util.Messages;
import java.util.ArrayList;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.Log;

public class PlanDiagramUtil {
    static final Log log = Log.getLog(PlanDiagramUtil.class);

    public static String askString(String dialogTitle, String dialogMessage, String initialValue) {
        String ret = null;
        Shell shell = PlanDiagramUtil.getShell();
        InputDialog inputDialog = new InputDialog(shell, dialogTitle, dialogMessage, initialValue, null);
        int retDialog = inputDialog.open();
        if (retDialog == 0) {
            ret = inputDialog.getValue();
        }
        return ret;
    }

    public static Color editColor(Color color) {
        if (color != null && color.eContainer() instanceof Diagram) {
            Shell shell = PlanDiagramUtil.getShell();
            ColorDialog colorDialog = new ColorDialog(shell);
            colorDialog.setText(Messages.DiagramUtil_ChooseColorTitel);
            colorDialog.setRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            RGB retRgb = colorDialog.open();
            if (retRgb == null) {
                return null;
            }
            Diagram diagram = (Diagram)color.eContainer();
            Color newColor = Graphiti.getGaService().manageColor(diagram, retRgb.red, retRgb.green, retRgb.blue);
            return newColor;
        }
        return null;
    }

    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static PlanNodeRenderInfo getRenderInfo(ICustomContext context) {
        if (context.getPictogramElements() == null) {
            return null;
        }
        if (context.getPictogramElements().length != 1) {
            return null;
        }
        if (context.getPictogramElements()[0].getLink() == null) {
            return null;
        }
        for (Object o : context.getPictogramElements()[0].getLink().getBusinessObjects()) {
            if (!(o instanceof PlanNodeRenderInfo)) continue;
            return (PlanNodeRenderInfo)((Object)o);
        }
        return null;
    }

    public static PlanNodeRenderInfo getRenderInfo(ILayoutContext context) {
        PictogramElement element = context.getPictogramElement();
        return PlanDiagramUtil.getRenderInfo(element);
    }

    public static PlanNodeRenderInfo getRenderInfo(PictogramElement element) {
        if (element == null || element.getLink() == null) {
            return null;
        }
        for (Object o : element.getLink().getBusinessObjects()) {
            if (!(o instanceof PlanNodeRenderInfo)) continue;
            return (PlanNodeRenderInfo)((Object)o);
        }
        return null;
    }

    public static void layoutNodeWithsiblings(PlanNodeRenderInfo renderInfo) {
        SQLPlan plan = renderInfo.getNode().getPlan();
        DiagramLayoutEngine.Parameters params = new DiagramLayoutEngine.Parameters();
        params.setOverrideDiagramConfig(true);
        params.getGlobalSettings().setProperty(CoreOptions.ANIMATE, (Object)false).setProperty(CoreOptions.PROGRESS_BAR, (Object)false).setProperty(CoreOptions.LAYOUT_ANCESTORS, (Object)false).setProperty(CoreOptions.ZOOM_TO_FIT, (Object)false);
        params.addLayoutRun((LayoutConfigurator)plan.getOwnerPart().getLayoutConfiguration());
        ArrayList<PictogramElement> diagramElements = new ArrayList<PictogramElement>(plan.getAllNodes().size());
        for (SQLPlanNode node : plan.getAllNodes()) {
            PictogramElement pe;
            if (!(node.getContainer() instanceof PictogramElement) || !(pe = (PictogramElement)node.getContainer()).isVisible()) continue;
            diagramElements.add(pe);
        }
        if (diagramElements.size() > 1) {
            try {
                DiagramLayoutEngine.invokeLayout((IWorkbenchPart)((IWorkbenchPart)plan.getOwnerPart().getHostPart()), diagramElements, (DiagramLayoutEngine.Parameters)params);
            }
            catch (Exception e) {
                log.error((Object)"Error during plan diagram layout", (Throwable)e);
            }
        }
    }

    public static void layoutConnections(PlanNodeRenderInfo renderInfo) {
        SQLPlan plan = renderInfo.getNode().getPlan();
        DiagramLayoutEngine.Parameters params = new DiagramLayoutEngine.Parameters();
        params.setOverrideDiagramConfig(true);
        params.getGlobalSettings().setProperty(CoreOptions.ANIMATE, (Object)false).setProperty(CoreOptions.PROGRESS_BAR, (Object)false).setProperty(CoreOptions.LAYOUT_ANCESTORS, (Object)false).setProperty(CoreOptions.ZOOM_TO_FIT, (Object)false);
        params.addLayoutRun((LayoutConfigurator)plan.getOwnerPart().getLayoutConfiguration());
        ArrayList diagramElements = new ArrayList();
        for (Anchor anchor : renderInfo.getContainerShape().getAnchors()) {
            diagramElements.addAll(anchor.getIncomingConnections());
        }
    }
}

