/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.features;

import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRender;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import com.dbeaver.ui.editors.sql.plan.diagram.util.StyleUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class PlanAddNodeFeature
extends AbstractAddShapeFeature {
    public static final int INVISIBLE_RECT_RIGHT = 6;

    public PlanAddNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object newObject = context.getNewObject();
        return newObject instanceof EObject && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        SQLPlanNode node = (SQLPlanNode)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        PlanNodeRenderInfo renderInfo = new PlanNodeRenderInfo(targetDiagram, node, context);
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        node.setContainer((Object)containerShape);
        renderInfo.setContainerShape(containerShape);
        if (node.isCollapsedBy()) {
            containerShape.setActive(false);
            containerShape.setVisible(false);
        }
        PlanNodeRender nodeRender = new PlanNodeRender(renderInfo);
        nodeRender.computeSize();
        int width = nodeRender.getNodeWidth();
        int height = nodeRender.getNodeHeight();
        IGaService gaService = Graphiti.getGaService();
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width, height);
        RoundedRectangle baseRectangle = gaService.createPlainRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 0, 0);
        baseRectangle.setStyle(StyleUtil.getStyleForNode(this.getDiagram(), node));
        gaService.setLocationAndSize((GraphicsAlgorithm)baseRectangle, 0, 0, width, height);
        renderInfo.setShape((GraphicsAlgorithm)baseRectangle);
        if (node.eResource() == null) {
            this.getDiagram().eResource().getContents().add((Object)node);
        }
        this.link((PictogramElement)containerShape, (Object)renderInfo);
        targetDiagram.getPictogramLinks().add((Object)containerShape.getLink());
        BoxRelativeAnchor boxAnchorIN = peCreateService.createBoxRelativeAnchor((AnchorContainer)containerShape);
        boxAnchorIN.setRelativeWidth(0.5);
        boxAnchorIN.setRelativeHeight(0.0);
        boxAnchorIN.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)baseRectangle);
        RoundedRectangle ellipseIN = gaService.createPlainRoundedRectangle((GraphicsAlgorithmContainer)boxAnchorIN, 0, 0);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipseIN, 0, 0, 1, 1);
        ellipseIN.setStyle(StyleUtil.getStyleForNode(this.getDiagram(), node));
        node.setAnchorIN((Object)boxAnchorIN);
        BoxRelativeAnchor boxAnchorOUT = peCreateService.createBoxRelativeAnchor((AnchorContainer)containerShape);
        boxAnchorOUT.setRelativeWidth(0.5);
        boxAnchorOUT.setRelativeHeight(1.0);
        boxAnchorOUT.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)baseRectangle);
        RoundedRectangle ellipseOUT = gaService.createPlainRoundedRectangle((GraphicsAlgorithmContainer)boxAnchorOUT, 0, 0);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipseOUT, 0, 0, 1, 1);
        ellipseOUT.setStyle(StyleUtil.getStyleForNode(this.getDiagram(), node));
        node.setAnchorOUT((Object)boxAnchorOUT);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        nodeRender.render();
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }

    private Text createTextShape(IGaService gaService, ContainerShape containerShape, int x, int y, int width, int height) {
        Shape shapeName = Graphiti.getPeCreateService().createShape(containerShape, false);
        Text textName = gaService.createPlainText((GraphicsAlgorithmContainer)shapeName, "N/A");
        gaService.setLocationAndSize((GraphicsAlgorithm)textName, x, y, width, height);
        this.link((PictogramElement)shapeName, textName);
        return textName;
    }
}

