/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

public class SqlVarChar
extends SqlData
implements ByteArray {
    private static final byte[] empty = new byte[0];
    protected byte[] value = empty;
    protected int limit = -1;
    protected int length = 0;
    protected CharSet charSet = null;

    public SqlVarChar(CharSet charSet) {
        super(true);
        this.charSet = charSet;
    }

    public SqlVarChar(CharSet charSet, int n) {
        this(charSet);
        this.limit = n;
    }

    @Override
    public int capacity() {
        return this.value.length;
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensure(n);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int n) {
        int n2 = this.limit = n < 0 ? -1 : n;
        if (this.limit >= 0 && this.length > this.limit) {
            this.length = this.limit;
        }
    }

    @Override
    public void limit(int n, boolean bl) {
        this.limit(n);
        if (bl) {
            this.ensure(n);
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void clear() {
        this.setNotNull();
        this.length = 0;
    }

    public void set(SqlVarChar sqlVarChar) {
        if (sqlVarChar == null || sqlVarChar.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlVarChar.value, 0, sqlVarChar.length);
        }
    }

    @Override
    public int put(byte by) {
        if (this.limit >= 0 && this.length >= this.limit) {
            return 0;
        }
        this.ensure(this.length + 1);
        this.value[this.length++] = by;
        return 1;
    }

    @Override
    public int put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    @Override
    public int put(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n3 = this.limit < 0 ? n2 : this.limit - this.length;
        if (n2 > n3) {
            n2 = n3;
        }
        this.ensure(this.length + n2);
        System.arraycopy(byArray, n, this.value, this.length, n2);
        this.length += n2;
        return n2;
    }

    @Override
    public byte get(int n) {
        return n >= this.length ? (byte)0 : this.value[n];
    }

    @Override
    public byte[] get() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.value, 0, byArray, 0, this.length);
        return byArray;
    }

    @Override
    public int get(byte[] byArray) {
        return this.get(0, byArray.length, byArray, 0);
    }

    @Override
    public int get(int n, int n2, byte[] byArray, int n3) {
        int n4;
        int n5 = n4 = n >= this.length ? 0 : this.length - n;
        if (n2 > n4) {
            n2 = n4;
        }
        System.arraycopy(this.value, n, byArray, n3, n2);
        return n2;
    }

    protected void ensure(int n) {
        if (this.limit >= 0 && n > this.limit) {
            n = this.limit;
        }
        if (n > this.value.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value, 0, byArray, 0, this.length);
            this.value = byArray;
        }
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setString(Boolean.toString(bl));
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setString(Byte.toString(by));
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setString(Short.toString(s));
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setString(Integer.toString(n));
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setString(Long.toString(l));
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setString(Float.toString(f));
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setString(Double.toString(d));
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            byte[] byArray;
            try {
                byArray = this.charSet.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
            }
            if (byArray.length > this.value.length) {
                int n = byArray.length;
                if (this.limit >= 0 && n > this.limit) {
                    n = this.limit;
                }
                this.setNotNull();
                this.value = byArray;
                this.length = n;
            } else {
                this.clear();
                this.put(byArray);
            }
        }
    }

    @Override
    public void setDate(Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatDate((java.util.Date)date, timeZone));
            } else {
                this.setString(sqlDates.formatDate((java.util.Date)date, false));
            }
        }
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        if (time == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatTime((java.util.Date)time, timeZone));
            } else {
                this.setString(sqlDates.formatTime((java.util.Date)time, false));
            }
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        if (timestamp == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatTimestamp((java.util.Date)timestamp, timeZone));
            } else {
                this.setString(sqlDates.formatTimestamp((java.util.Date)timestamp, false));
            }
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        String string = this.getString(this.length).trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    @Override
    public byte getByte() throws SQLException {
        byte by;
        try {
            by = Byte.parseByte(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    @Override
    public short getShort() throws SQLException {
        short s;
        try {
            s = Short.parseShort(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    @Override
    public int getInt() throws SQLException {
        int n;
        try {
            n = Integer.parseInt(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    @Override
    public long getLong() throws SQLException {
        long l;
        try {
            l = Long.parseLong(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    @Override
    public float getFloat() throws SQLException {
        float f;
        try {
            f = Float.parseFloat(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    @Override
    public double getDouble() throws SQLException {
        double d;
        try {
            d = Double.parseDouble(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.getString(this.length).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    @Override
    public String getString() throws SQLException {
        return this.getString(this.length);
    }

    @Override
    public String getString(int n) throws SQLException {
        if (n > this.length) {
            n = this.length;
        }
        try {
            return this.charSet.getString(this.value, 0, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.getBytes(this.length);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (n > this.length) {
            n = this.length;
        }
        byte[] byArray = new byte[n];
        this.get(0, n, byArray, 0);
        return byArray;
    }

    @Override
    public Date getDate(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString(this.length).trim();
        return timeZone == null ? sqlDates.parseDate(string, false) : sqlDates.parseDate(string, timeZone);
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString(this.length).trim();
        return timeZone == null ? sqlDates.parseTime(string, false) : sqlDates.parseTime(string, timeZone);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString(this.length).trim();
        return timeZone == null ? sqlDates.parseTimestamp(string, false) : sqlDates.parseTimestamp(string, timeZone);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return SqlVarChar.getBinary(this.value, 0, this.length);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return SqlVarChar.getAscii(this.getString());
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return SqlVarChar.getUnicode(this.getString());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return SqlVarChar.getCharacter(this.getString());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getString();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.getString(n);
    }
}

