/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.CharBuffer;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class BufferedClob
implements Clob,
GcfErr {
    private CharBuffer buff = null;

    public BufferedClob() {
        this.buff = new CharBuffer();
    }

    public BufferedClob(int n) {
        this.buff = new CharBuffer(n);
    }

    public BufferedClob(Reader reader) {
        this.buff = new CharBuffer(reader);
    }

    public BufferedClob(int n, Reader reader) {
        this.buff = new CharBuffer(n, reader);
    }

    public BufferedClob(CharBuffer charBuffer) {
        this.buff = charBuffer;
    }

    @Override
    public void free() throws SQLException {
        if (this.buff != null) {
            this.buff.free();
            this.buff = null;
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkValid();
        return this.buff.length();
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        this.checkValid();
        if (l < 1L || n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        long l2 = this.buff.length();
        l = Math.min(l - 1L, l2);
        n = (int)Math.max(0L, Math.min(l2 - l, (long)n));
        char[] cArray = new char[n];
        if (n > 0 && (int)this.buff.read(l, cArray, 0, n) != n) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return new String(cArray);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValid();
        return this.buff.getRdr();
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValid();
        if (l < 1L || l2 < 0L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.buff.getRdr(l - 1L, l2);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValid();
        return SqlStream.getAsciiIS(this.buff.getRdr());
    }

    @Override
    public long position(String string, long l) throws SQLException {
        this.checkValid();
        if (string == null || l < 1L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return (l = this.buff.find(string, l - 1L)) >= 0L ? l + 1L : -1L;
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        this.checkValid();
        if (clob == null || (l2 = clob.length()) > Integer.MAX_VALUE) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.position(clob.getSubString(1L, (int)l2), l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        this.checkValid();
        if (string == null) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkValid();
        if (string == null || n2 < 0 || l < 1L || l > this.buff.length() + 1L || n < 0 || n >= string.length()) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return (int)this.buff.write(l - 1L, string, n, n2);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        this.checkValid();
        Writer writer = this.buff.getWtr(l - 1L);
        if (writer == null) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return writer;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkValid();
        Writer writer = this.buff.getWtr(l - 1L);
        if (writer == null) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return SqlStream.getAsciiOS(writer);
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkValid();
        if (l < 0L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.buff.truncate(l);
    }

    private void checkValid() throws SQLException {
        if (this.buff == null) {
            throw SqlExFactory.get(ERR_GC4022_LOB_FREED);
        }
    }
}

