/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model.plan;

import com.dbeaver.db.mssql.model.plan.SQLServerPlanNode;
import com.dbeaver.db.mssql.model.plan.SQLServerPlanParser;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class SQLServerExecutionPlan
extends AbstractExecutionPlan {
    private static final String TURN_PLAN_ON = "SET STATISTICS XML ON";
    private String query;
    private List<DBCPlanNode> nodes;
    private static final Log log = Log.getLog(SQLServerExecutionPlan.class);

    public SQLServerExecutionPlan(String query) {
        this.query = query;
    }

    public SQLServerExecutionPlan(String query, List<SQLServerPlanNode> rootNodes) {
        this.query = query;
        this.nodes = new ArrayList<DBCPlanNode>(rootNodes.size());
        this.nodes.addAll(rootNodes);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() throws DBException {
        return this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.nodes;
    }

    public void explain(DBCSession session) throws DBCException {
        block42: {
            JDBCSession connection = (JDBCSession)session;
            boolean oldAutoCommit = false;
            try {
                try {
                    oldAutoCommit = connection.getAutoCommit();
                    if (oldAutoCommit) {
                        connection.setAutoCommit(false);
                    }
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (JDBCStatement dbStat = connection.createStatement();){
                        dbStat.execute(TURN_PLAN_ON);
                        try {
                            Throwable throwable2 = null;
                            Object var8_13 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery(this.query);){
                                if (dbStat.getMoreResults()) {
                                    Throwable throwable3 = null;
                                    Object var11_18 = null;
                                    try (JDBCResultSet planResult = dbStat.getResultSet();){
                                        if (planResult.next()) {
                                            this.nodes = SQLServerPlanParser.getInstance().parse(planResult.getString(1), this.query);
                                            break block42;
                                        }
                                        throw new DBCException("Query plan not available");
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                }
                                throw new DBCException("Query plan not supported");
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Exception e) {
                            throw new DBCException("Can't parse plan XML", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, session.getExecutionContext());
                }
            }
            finally {
                try {
                    connection.rollback();
                    if (oldAutoCommit) {
                        connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"Error closing plan analyser", (Throwable)e);
                }
            }
        }
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }
}

