/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.data.spatial.reader;

import com.dbeaver.db.mssql.data.spatial.reader.Figure;
import com.dbeaver.db.mssql.data.spatial.reader.Shape;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

class SqlServerBinary {
    private int srid;
    private int numberOfPoints;
    private Coordinate[] coordinates;
    private Shape[] shapes;
    private Figure[] figures;
    private CoordinateSequence[] sequences;
    private byte serializationProperties;

    SqlServerBinary() {
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public void setSerializationProperties(byte serializationProperties) {
        this.serializationProperties = serializationProperties;
    }

    public boolean hasZ() {
        return (this.serializationProperties & 1) == 1;
    }

    public boolean hasM() {
        return (this.serializationProperties & 2) == 2;
    }

    public boolean isValid() {
        return (this.serializationProperties & 4) == 4;
    }

    public boolean isSinglePoint() {
        return (this.serializationProperties & 8) == 8;
    }

    public boolean hasSingleLineSegment() {
        return (this.serializationProperties & 0x10) == 16;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public void setNumberOfPoints(int numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Coordinate[] coordinates) {
        this.coordinates = coordinates;
    }

    public void setShapes(Shape[] shapes) {
        this.shapes = shapes;
    }

    public void setFigures(Figure[] figures) {
        this.figures = figures;
    }

    public Figure[] getFigures() {
        return this.figures;
    }

    public void setSequences(CoordinateSequence[] sequences) {
        this.sequences = sequences;
    }

    public Shape[] getShapes() {
        return this.shapes;
    }

    public Shape getShape(int index) {
        return this.shapes[index];
    }

    public Figure getFigure(int index) {
        return this.figures[index];
    }

    public CoordinateSequence getSequence(int index) {
        return this.sequences[index];
    }
}

