/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;

public abstract class PBE {
    protected PBEAlgorithmIdentifier a;
    protected AlgorithmIdentifier b;
    protected AlgorithmIdentifier c;

    protected PBE() {
    }

    public static PBE getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        PBE pBE;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "pbe");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            pBE = (PBE)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement PBE.");
        }
        pBE.initialize(algorithmIdentifier);
        return pBE;
    }

    public abstract void initialize(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public abstract void initialize(int var1, byte[] var2, int var3) throws AlgorithmIdentifierException;

    public abstract void initialize(int var1) throws AlgorithmIdentifierException;

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public abstract byte[] encryptPrivateKey(String var1, PrivateKey var2) throws CipherException;

    public abstract PrivateKey decryptPrivateKey(String var1, byte[] var2) throws CipherException, IOException;

    public abstract byte[] encryptSymmetricKey(String var1, SymmetricKey var2) throws CipherException;

    public abstract SymmetricKey decryptSymmetricKey(String var1, byte[] var2) throws CipherException;

    public abstract byte[] encrypt(String var1, byte[] var2) throws CipherException;

    public abstract byte[] decrypt(String var1, byte[] var2) throws CipherException;

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

