/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest a;

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.a = messageDigest;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.a.update((byte)n);
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.write(byArray[i]);
        }
    }

    public byte[] computeCurrent() {
        this.a.computeCurrent();
        return this.a.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.a;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.a = messageDigest;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

