/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.relique.io.TableReader;
import org.relique.jdbc.csv.CsvResources;

public class ZipFileTableReader
implements TableReader {
    private String zipFilename;
    private ZipFile zipFile;
    private String fileExtension;
    private String charset;

    public ZipFileTableReader(String zipFilename, String charset) throws IOException {
        this.zipFilename = zipFilename;
        this.zipFile = new ZipFile(zipFilename);
        this.charset = charset;
    }

    public void setExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    @Override
    public Reader getReader(Statement statement, String tableName) throws SQLException {
        try {
            ZipEntry zipEntry = this.zipFile.getEntry(tableName + this.fileExtension);
            if (zipEntry == null) {
                throw new SQLException(CsvResources.getString("tableNotFound") + ": " + tableName);
            }
            InputStreamReader reader = this.charset != null ? new InputStreamReader(this.zipFile.getInputStream(zipEntry), this.charset) : new InputStreamReader(this.zipFile.getInputStream(zipEntry));
            return reader;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public List<String> getTableNames(Connection connection) throws SQLException {
        Vector<String> v = new Vector<String>();
        Enumeration<? extends ZipEntry> en = this.zipFile.entries();
        while (en.hasMoreElements()) {
            String name = en.nextElement().getName();
            if (name.endsWith(this.fileExtension)) {
                name = name.substring(0, name.length() - this.fileExtension.length());
            }
            v.add(name);
        }
        return v;
    }
}

