/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLMaxFunction
extends AggregateFunction {
    boolean isDistinct;
    Expression expression;
    Object max = null;

    public SQLMaxFunction(boolean isDistinct, Expression expression) {
        this.isDistinct = isDistinct;
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object o = env.get("@GROUPROWS");
        if (o != null) {
            List groupRows = (List)o;
            Object maxInGroup = null;
            for (int i = 0; i < groupRows.size(); ++i) {
                o = this.expression.eval((Map)groupRows.get(i));
                if (o == null || maxInGroup != null && ((Comparable)maxInGroup).compareTo(o) >= 0) continue;
                maxInGroup = o;
            }
            return maxInGroup;
        }
        return this.max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MAX(");
        if (this.isDistinct) {
            sb.append("DISTINCT ");
        }
        sb.append(this.expression);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        return new LinkedList<String>();
    }

    @Override
    public List<String> aggregateColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.add(this);
        return result;
    }

    @Override
    public void resetAggregateFunctions() {
        this.max = null;
    }

    @Override
    public void processRow(Map<String, Object> env) throws SQLException {
        Object o = this.expression.eval(env);
        if (o != null && (this.max == null || ((Comparable)this.max).compareTo(o) < 0)) {
            this.max = o;
        }
    }
}

