/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.relique.io.CryptoFilter;

public class XORCipher
implements CryptoFilter {
    private int keyCounter;
    private int[] scrambleKey;

    public XORCipher(String seed) {
        this.scrambleKey = new int[seed.length()];
        for (int i = 0; i < seed.length(); ++i) {
            this.scrambleKey[i] = seed.charAt(i);
        }
        this.keyCounter = 0;
    }

    @Override
    public int read(InputStream in) throws IOException {
        if (in.available() > 0) {
            return (byte)this.scrambleInt(in.read());
        }
        return -1;
    }

    @Override
    public int read(InputStream in, byte[] b) throws IOException {
        int len = in.read(b, 0, b.length);
        this.scrambleArray(b);
        return len;
    }

    @Override
    public int read(InputStream in, byte[] b, int off, int len) throws IOException {
        len = in.read(b, off, len);
        this.scrambleArray(b);
        return len;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("XORCipher(");
        sb.append(this.scrambleKey.length);
        sb.append("):'");
        for (int i = 0; i < this.scrambleKey.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(i);
        }
        sb.append("'");
        return sb.toString();
    }

    private int scrambleInt(int org) {
        int encrDataChar = org;
        if (this.scrambleKey.length > 0) {
            encrDataChar = org ^ this.scrambleKey[this.keyCounter];
            ++this.keyCounter;
            this.keyCounter %= this.scrambleKey.length;
        }
        return encrDataChar;
    }

    private void scrambleArray(byte[] org) {
        if (this.scrambleKey.length > 0) {
            int i = 0;
            while (i < org.length) {
                int n = i++;
                org[n] = (byte)(org[n] ^ this.scrambleKey[this.keyCounter]);
                ++this.keyCounter;
                this.keyCounter %= this.scrambleKey.length;
            }
        }
    }

    @Override
    public void write(OutputStream out, int ch) throws IOException {
        out.write(this.scrambleInt(ch));
    }

    @Override
    public void reset() {
        this.keyCounter = 0;
    }
}

