/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relique.io.DataReader;

public class ListDataReader
extends DataReader {
    private String[] columnNames;
    private String[] columnTypes;
    private List<Object[]> columnValues;
    private int rowIndex;

    public ListDataReader(String[] columnNames, String[] columnTypes, List<Object[]> columnValues) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.columnValues = columnValues;
        this.rowIndex = -1;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.rowIndex;
        boolean retval = this.rowIndex < this.columnValues.size();
        return retval;
    }

    @Override
    public String[] getColumnNames() throws SQLException {
        return this.columnNames;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public Map<String, Object> getEnvironment() throws SQLException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        Object[] o = this.columnValues.get(this.rowIndex);
        for (int i = 0; i < this.columnNames.length; ++i) {
            retval.put(this.columnNames[i], o[i]);
        }
        return retval;
    }

    @Override
    public String[] getColumnTypes() throws SQLException {
        return this.columnTypes;
    }

    @Override
    public int[] getColumnSizes() throws SQLException {
        int[] columnSizes = new int[this.columnTypes.length];
        Arrays.fill(columnSizes, 20);
        return columnSizes;
    }

    @Override
    public String getTableAlias() {
        return null;
    }
}

