/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import org.mockito.Mockito;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.plugins.MockMaker;

public class MockUtil {
    private static final MockMaker mockMaker = Plugins.getMockMaker();

    private MockUtil() {
    }

    public static MockMaker.TypeMockability typeMockabilityOf(Class<?> type) {
        return mockMaker.isTypeMockable(type);
    }

    public static <T> T createMock(MockCreationSettings<T> settings) {
        InternalMockHandler<T> mockHandler = MockHandlerFactory.createMockHandler(settings);
        T mock = mockMaker.createMock(settings, mockHandler);
        Object spiedInstance = settings.getSpiedInstance();
        if (spiedInstance != null) {
            new LenientCopyTool().copyToMock(spiedInstance, mock);
        }
        return mock;
    }

    public static <T> void resetMock(T mock) {
        InternalMockHandler<T> oldHandler = MockUtil.getMockHandler(mock);
        MockCreationSettings<T> settings = oldHandler.getMockSettings();
        InternalMockHandler<T> newHandler = MockHandlerFactory.createMockHandler(settings);
        mockMaker.resetMock(mock, newHandler, settings);
    }

    public static <T> InternalMockHandler<T> getMockHandler(T mock) {
        if (mock == null) {
            throw new NotAMockException("Argument should be a mock, but is null!");
        }
        if (MockUtil.isMock(mock)) {
            MockHandler handler = mockMaker.getHandler(mock);
            return (InternalMockHandler)handler;
        }
        throw new NotAMockException("Argument should be a mock, but is: " + mock.getClass());
    }

    public static boolean isSpy(Object mock) {
        return MockUtil.isMock(mock) && MockUtil.getMockSettings(mock).getDefaultAnswer() == Mockito.CALLS_REAL_METHODS;
    }

    public static boolean isMock(Object mock) {
        return mock != null && mockMaker.getHandler(mock) != null;
    }

    public static MockName getMockName(Object mock) {
        return MockUtil.getMockHandler(mock).getMockSettings().getMockName();
    }

    public static void maybeRedefineMockName(Object mock, String newName) {
        MockName mockName = MockUtil.getMockName(mock);
        MockCreationSettings<Object> mockSettings = MockUtil.getMockHandler(mock).getMockSettings();
        if (mockName.isDefault() && mockSettings instanceof CreationSettings) {
            ((CreationSettings)mockSettings).setMockName(new MockNameImpl(newName));
        }
    }

    public static MockCreationSettings getMockSettings(Object mock) {
        return MockUtil.getMockHandler(mock).getMockSettings();
    }
}

