/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.views;

import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.influxdb.InfluxDB;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;

public class InfluxConsistencyLevelContributor
extends DataSourceMenuContributor {
    protected void fillContributionItems(List<IContributionItem> menuItems) {
        DBCExecutionContext executionContext;
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IEditorPart activePart = window.getActivePage().getActiveEditor();
        if (activePart instanceof DBPContextProvider && (executionContext = ((DBPContextProvider)activePart).getExecutionContext()) instanceof InfluxExecutionContext) {
            InfluxDB.ConsistencyLevel currentCL = ((InfluxExecutionContext)executionContext).getCurrentConsistencyLevel();
            InfluxDB.ConsistencyLevel[] consistencyLevelArray = InfluxDB.ConsistencyLevel.values();
            int n = consistencyLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                InfluxDB.ConsistencyLevel cl = consistencyLevelArray[n2];
                menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new ConsistencyLevelAction((InfluxExecutionContext)executionContext, cl, cl.equals((Object)currentCL)), (boolean)true));
                ++n2;
            }
        }
    }

    private static class ConsistencyLevelAction
    extends Action {
        private final InfluxExecutionContext executionContext;
        private final InfluxDB.ConsistencyLevel level;
        private final boolean checked;

        public ConsistencyLevelAction(InfluxExecutionContext executionContext, InfluxDB.ConsistencyLevel level, boolean isCurrent) {
            this.executionContext = executionContext;
            this.level = level;
            this.checked = isCurrent;
        }

        public int getStyle() {
            return 8;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public String getText() {
            return this.level.name();
        }

        public void run() {
            this.executionContext.setCurrentConsistencyLevel(this.level);
        }
    }
}

