/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.internal;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.ui.notifications.NotificationUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.bundle.EventHook;

public class CoreApplicationActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.ui.app.standalone";
    private static CoreApplicationActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DBeaverNotifications.setHandler((DBeaverNotifications.NotificationHandler)new DBeaverNotifications.NotificationHandler(){

            public void sendNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType, Runnable feedback) {
                NotificationUtils.sendNotification((DBPDataSource)dataSource, (String)id, (String)text, (DBPMessageType)messageType, (Runnable)feedback);
            }

            public void sendNotification(String id, String title, String text, DBPMessageType messageType, Runnable feedback) {
                NotificationUtils.sendNotification((String)id, (String)title, (String)text, (DBPMessageType)messageType, (Runnable)feedback);
            }
        });
        if (!Log.isQuietMode()) {
            context.registerService(EventHook.class, (event, contexts) -> {
                String message = null;
                Bundle bundle = event.getBundle();
                if (event.getType() == 2) {
                    if (bundle.getState() == 32) {
                        message = "> Start " + CoreApplicationActivator.getBundleName(bundle) + " [" + bundle.getSymbolicName() + " " + bundle.getVersion() + "]";
                    }
                } else if (event.getType() == 256 && bundle.getState() != 256 && bundle.getState() != 16) {
                    message = "< Stop " + CoreApplicationActivator.getBundleName(bundle) + " [" + bundle.getSymbolicName() + " " + bundle.getVersion() + "]";
                }
                if (message != null) {
                    System.err.println(message);
                }
            }, null);
        }
        plugin = this;
    }

    private static String getBundleName(Bundle bundle) {
        String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
        if (CommonUtils.isEmpty((String)bundleName)) {
            bundleName = bundle.getSymbolicName();
        }
        return bundleName;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CoreApplicationActivator getDefault() {
        return plugin;
    }
}

