/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.FireBirdUtils;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableBase;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class FireBirdTable
extends GenericTable
implements FireBirdTableBase,
DBPNamedObject2 {
    private int keyLength;
    private String externalFile;
    private String ownerName;
    private Map<String, String> columnDomainTypes;

    public FireBirdTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, null);
        if (dbResult != null) {
            this.keyLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$DBKEY_LENGTH");
            this.externalFile = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$EXTERNAL_FILE");
            this.ownerName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$OWNER_NAME");
        }
    }

    @Override
    @Property(viewable=true, order=20)
    public String getOwnerName() {
        return this.ownerName;
    }

    @Property(viewable=true, order=21)
    public int getKeyLength() {
        return this.keyLength;
    }

    @Property(viewable=true, order=22)
    public String getExternalFile() {
        return this.externalFile;
    }

    protected boolean isTruncateSupported() {
        return false;
    }

    @Override
    public synchronized List<FireBirdTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List childColumns = super.getAttributes(monitor);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<FireBirdTableColumn> columns = new ArrayList<FireBirdTableColumn>();
        for (GenericTableColumn gtc : childColumns) {
            columns.add((FireBirdTableColumn)gtc);
        }
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    @Override
    public String getColumnDomainType(DBRProgressMonitor monitor, FireBirdTableColumn column) throws DBException {
        if (this.columnDomainTypes == null) {
            this.columnDomainTypes = FireBirdUtils.readColumnDomainTypes(monitor, (GenericTableBase)this);
        }
        return this.columnDomainTypes.get(column.getName());
    }
}

