/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class FireBirdTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn>,
DBEObjectReorderer<GenericTableColumn> {
    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericTableColumn> command, Map<String, Object> options) {
        String autoIncrementClause;
        StringBuilder decl = super.getNestedDeclaration(monitor, owner, command, options);
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (column.isAutoIncrement() && (autoIncrementClause = column.getDataSource().getMetaModel().getAutoIncrementClause(column)) != null && !autoIncrementClause.isEmpty()) {
            decl.append(" ").append(autoIncrementClause);
        }
        return decl;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, this.NotNullModifier};
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        if (command.getProperty((Object)"typeName") != null || command.getProperty((Object)"maxLength") != null || command.getProperty((Object)"precision") != null || command.getProperty((Object)"scale") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column type", String.valueOf(prefix) + "TYPE " + typeClause));
        }
        if (command.getProperty((Object)"defaultValue") != null) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop column default", String.valueOf(prefix) + "DROP DEFAULT"));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column default", String.valueOf(prefix) + "SET DEFAULT " + column.getDefaultValue()));
            }
        }
        if (command.getProperty((Object)"description") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)column.getTable()) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(DBECommandContext commandContext, GenericTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectReorderActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectReorderCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Reorder column", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((GenericTableColumn)command.getObject()).getTable()) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " POSITION " + column.getOrdinalPosition()));
    }

    public int getMinimumOrdinalPosition(GenericTableColumn object) {
        return 1;
    }

    public int getMaximumOrdinalPosition(GenericTableColumn object) {
        try {
            return ((GenericTableBase)object.getTable()).getAttributes((DBRProgressMonitor)new VoidProgressMonitor()).size();
        }
        catch (DBException e) {
            log.error((Object)"Error reading columns for maximum order position", (Throwable)e);
            return 0;
        }
    }

    public void setObjectOrdinalPosition(DBECommandContext commandContext, GenericTableColumn object, List<GenericTableColumn> siblingObjects, int newPosition) throws DBException {
        this.processObjectReorder(commandContext, (DBSObject)object, siblingObjects, newPosition);
    }
}

