/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.iam;

import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.net.auth.iam.AuthModelIAMAbstract;
import com.dbeaver.ui.auth.iam.AuthModelIAMMessages;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;

public class AuthModelIAMConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private static final Log log = Log.getLog(AuthModelIAMConfigurator.class);
    private Label usernameLabel;
    private Label regionLabel;
    private Combo regionCombo;
    private Combo authTypeCombo;
    private Label awsAccessKeyLabel;
    private Text awsAccessKeyText;
    private Label awsSecretKeyLabel;
    private Text awsSecretKeyText;
    private Label awsProfileNameLabel;
    private Combo awsProfileNameCombo;
    private Control awsProfileFiller;
    private Button use3rdPartyAccessCheckbox;
    private Label iamAccountIdLabel;
    private Text iamAccountIdText;
    private Label iamRoleNameLabel;
    private Text iamRoleNameText;
    private ConfigType curConfigType = ConfigType.KEY;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite iamGroup = parent;
        Composite authGroup = UIUtils.createComposite((Composite)iamGroup, (int)4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        authGroup.setLayoutData((Object)gd);
        this.usernameLabel = UIUtils.createControlLabel((Composite)authGroup, (String)AuthModelIAMMessages.model_iam_database_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(authGroup, propertyChangeListener);
        gd = new GridData(768);
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.setToolTipText(AuthModelIAMMessages.model_iam_database_username_tip);
        this.regionLabel = new Label(authGroup, 131072);
        this.regionLabel.setText(String.valueOf(AuthModelIAMMessages.model_iam_region) + ":");
        gd = new GridData(128);
        this.regionLabel.setLayoutData((Object)gd);
        this.regionCombo = new Combo(authGroup, 4);
        gd = new GridData(768);
        this.regionCombo.setLayoutData((Object)gd);
        this.regionCombo.setToolTipText(AuthModelIAMMessages.model_iam_region_help);
        this.createIAMAuthControls(authGroup, propertyChangeListener);
    }

    public void createIAMAuthControls(Composite iamGroup, final Runnable propertyChangeListener) {
        SelectionAdapter selChangelistener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        };
        boolean isWide = ((GridLayout)iamGroup.getLayout()).numColumns > 2;
        this.authTypeCombo = UIUtils.createLabelCombo((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_auth_type, (String)AuthModelIAMMessages.model_iam_auth_type_tip, (int)12);
        ConfigType[] configTypeArray = ConfigType.values();
        int n = configTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigType ct = configTypeArray[n2];
            this.authTypeCombo.add(ct.getTitle());
            ++n2;
        }
        this.authTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigType ct = (ConfigType)CommonUtils.fromOrdinal(ConfigType.class, (int)AuthModelIAMConfigurator.this.authTypeCombo.getSelectionIndex());
                AuthModelIAMConfigurator.this.changeAuthType(ct);
                propertyChangeListener.run();
            }
        });
        if (isWide) {
            ((GridData)this.authTypeCombo.getLayoutData()).widthHint = 150;
            new Label(iamGroup, 0);
            Label filler = new Label(iamGroup, 0);
            GridData gd = new GridData(768);
            gd.widthHint = 150;
            filler.setLayoutData((Object)gd);
        }
        this.awsAccessKeyLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_access_key);
        this.awsAccessKeyText = new Text(iamGroup, 2048);
        GridData gd = new GridData(768);
        this.awsAccessKeyText.setLayoutData((Object)gd);
        this.awsAccessKeyText.setToolTipText(AuthModelIAMMessages.model_iam_aws_access_key_help);
        this.awsAccessKeyText.addModifyListener(e -> propertyChangeListener.run());
        this.awsSecretKeyLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_secret_key);
        ((GridData)this.awsSecretKeyLabel.getLayoutData()).horizontalAlignment = 3;
        this.awsSecretKeyText = new Text(iamGroup, 0x400800);
        gd = new GridData(768);
        this.awsSecretKeyText.setLayoutData((Object)gd);
        this.awsSecretKeyText.setToolTipText(AuthModelIAMMessages.model_iam_aws_secret_key_help);
        this.awsSecretKeyText.addModifyListener(e -> propertyChangeListener.run());
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)iamGroup, (String)"Save credentials locally", (String)"Save access/secret keys in local secured storage", (this.dataSource == null || this.dataSource.isSavePassword() ? 1 : 0) != 0, (int)(isWide ? 4 : 2));
        this.savePasswordCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally);
        this.savePasswordCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelIAMConfigurator.this.enableAccessControls();
            }
        });
        this.awsProfileNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_profile_name);
        this.awsProfileNameCombo = new Combo(iamGroup, 12);
        gd = new GridData(768);
        this.awsProfileNameCombo.setLayoutData((Object)gd);
        this.awsProfileNameCombo.setToolTipText(AuthModelIAMMessages.model_iam_aws_profile_name_tip);
        for (Profile profile : ProfileFile.defaultProfileFile().profiles().values()) {
            this.awsProfileNameCombo.add(profile.name());
        }
        this.awsProfileNameCombo.addSelectionListener((SelectionListener)selChangelistener);
        if (isWide) {
            this.awsProfileFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.use3rdPartyAccessCheckbox = UIUtils.createCheckbox((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_use_cross_account, (String)AuthModelIAMMessages.model_iam_use_cross_account_tip, (boolean)false, (int)(isWide ? 4 : 2));
        this.use3rdPartyAccessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelIAMConfigurator.this.updateIAMSettingsVisibility();
            }
        });
        this.iamAccountIdLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_account_id);
        this.iamAccountIdText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        this.iamAccountIdText.setLayoutData((Object)gd);
        this.iamAccountIdText.setToolTipText(AuthModelIAMMessages.model_iam_aws_account_id_tip);
        this.iamRoleNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_role_name);
        ((GridData)this.iamRoleNameLabel.getLayoutData()).horizontalAlignment = 3;
        this.iamRoleNameText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        this.iamRoleNameText.setLayoutData((Object)gd);
        this.iamRoleNameText.setToolTipText(AuthModelIAMMessages.model_iam_aws_role_name_tip);
    }

    private void enableAccessControls() {
        this.awsAccessKeyText.setEnabled(this.savePasswordCheck.getSelection());
        this.awsSecretKeyText.setEnabled(this.savePasswordCheck.getSelection());
    }

    private void changeAuthType(ConfigType ct) {
        this.curConfigType = ct;
        this.updateIAMSettingsVisibility();
    }

    private void updateIAMSettingsVisibility() {
        boolean akVisible = this.curConfigType == ConfigType.KEY;
        UIUtils.setControlVisible((Control)this.awsAccessKeyLabel, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsAccessKeyText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSecretKeyLabel, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSecretKeyText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.savePasswordCheck, (boolean)akVisible);
        boolean pnVisible = this.curConfigType == ConfigType.PROFILE;
        UIUtils.setControlVisible((Control)this.awsProfileNameLabel, (boolean)pnVisible);
        UIUtils.setControlVisible((Control)this.awsProfileNameCombo, (boolean)pnVisible);
        if (this.awsProfileFiller != null) {
            UIUtils.setControlVisible((Control)this.awsProfileFiller, (boolean)pnVisible);
        }
        boolean accountIdEnabled = this.use3rdPartyAccessCheckbox.getSelection();
        UIUtils.setControlVisible((Control)this.iamAccountIdLabel, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamAccountIdText, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamRoleNameLabel, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamRoleNameText, (boolean)accountIdEnabled);
        this.awsAccessKeyText.getShell().layout(true, true);
    }

    public void loadSettings(DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        DBAAuthModel authModel = configuration.getAuthModel();
        if (!(authModel instanceof AuthModelIAMAbstract) || !((AuthModelIAMAbstract)authModel).supportsDatabaseUser()) {
            UIUtils.setControlVisible((Control)this.usernameLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.usernameText, (boolean)false);
            UIUtils.setControlVisible((Control)this.regionLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.regionCombo, (boolean)false);
            this.usernameLabel.getParent().getParent().layout(true, true);
        }
        List<String> regions = AuthModelIAMConfigurator.getPublicRegions();
        for (String region : regions) {
            this.regionCombo.add(region);
        }
        if (!CommonUtils.isEmpty((String)configuration.getAuthProperty("iam.region"))) {
            this.regionCombo.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("iam.region")));
        }
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        if (configuration.getAuthProperties() != null) {
            authProperties.putAll(configuration.getAuthProperties());
        }
        if (!authProperties.containsKey("iam.aws_access_key") && !CommonUtils.isEmpty((String)configuration.getUserName()) && configuration.getUserName().length() == 20) {
            authProperties.put("iam.aws_access_key", configuration.getUserName());
        }
        if (!authProperties.containsKey("iam.aws_secret_key") && !CommonUtils.isEmpty((String)configuration.getUserPassword()) && configuration.getUserPassword().length() == 40) {
            authProperties.put("iam.aws_secret_key", configuration.getUserPassword());
        }
        this.loadIAMAuthSettings(authProperties);
        this.savePasswordCheck.setSelection(dataSource.isSavePassword());
        boolean isCloudProvided = dataSource.getOrigin() instanceof DataSourceOriginCloud;
        this.authTypeCombo.setEnabled(!isCloudProvided);
        this.awsAccessKeyText.setEnabled(!isCloudProvided);
        this.awsSecretKeyText.setEnabled(!isCloudProvided);
        this.regionCombo.setEnabled(!isCloudProvided);
        this.awsProfileNameCombo.setEnabled(!isCloudProvided);
        this.use3rdPartyAccessCheckbox.setEnabled(!isCloudProvided);
        this.iamAccountIdText.setEnabled(!isCloudProvided);
        this.iamRoleNameText.setEnabled(!isCloudProvided);
        if (!isCloudProvided) {
            this.enableAccessControls();
        }
    }

    @NotNull
    public static List<String> getPublicRegions() {
        return Region.regions().stream().map(Region::id).filter(r -> !r.startsWith("aws") && !r.contains("-iso") && !r.contains("-gov")).sorted().collect(Collectors.toList());
    }

    public void loadIAMAuthSettings(Map<String, String> authProperties) {
        this.curConfigType = ConfigType.KEY;
        if (CommonUtils.getBoolean((String)authProperties.get("iam.use_default_aws"), (boolean)Boolean.FALSE)) {
            this.curConfigType = ConfigType.DEFAULT;
        }
        if (!CommonUtils.isEmpty((String)CommonUtils.toString((Object)authProperties.get("iam.profile_name")))) {
            this.curConfigType = ConfigType.PROFILE;
        }
        this.authTypeCombo.select(this.curConfigType.ordinal());
        this.awsAccessKeyText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_access_key")));
        this.awsSecretKeyText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_secret_key")));
        this.awsProfileNameCombo.setText(CommonUtils.notEmpty((String)authProperties.get("iam.profile_name")));
        this.iamAccountIdText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.account_id")));
        this.iamRoleNameText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.role_name")));
        this.use3rdPartyAccessCheckbox.setSelection(CommonUtils.getBoolean((String)authProperties.get("iam.cross_account_access"), (boolean)Boolean.FALSE));
        this.updateIAMSettingsVisibility();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("iam.region", this.regionCombo.getText());
        this.saveIAMAuthSettings(props);
        configuration.setAuthProperties(props);
        dataSource.setSavePassword(this.savePasswordCheck.getSelection());
    }

    public void saveIAMAuthSettings(Map<String, String> props) {
        if (this.curConfigType == ConfigType.KEY && this.savePasswordCheck.getSelection()) {
            props.put("iam.aws_access_key", this.awsAccessKeyText.getText());
            props.put("iam.aws_secret_key", this.awsSecretKeyText.getText());
        } else {
            props.remove("iam.aws_access_key");
            props.remove("iam.aws_secret_key");
        }
        if (this.curConfigType == ConfigType.PROFILE) {
            props.put("iam.profile_name", this.awsProfileNameCombo.getText());
        }
        props.put("iam.use_default_aws", String.valueOf(this.curConfigType == ConfigType.DEFAULT));
        props.put("iam.account_id", this.iamAccountIdText.getText());
        props.put("iam.role_name", this.iamRoleNameText.getText());
        props.put("iam.cross_account_access", String.valueOf(this.use3rdPartyAccessCheckbox.getSelection()));
    }

    public void resetSettings(DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        switch (this.curConfigType) {
            case KEY: {
                return true;
            }
            case DEFAULT: {
                return true;
            }
            case PROFILE: {
                return this.awsProfileNameCombo.getSelectionIndex() >= 0;
            }
        }
        return false;
    }

    static enum ConfigType {
        KEY("Access/secret keys"),
        DEFAULT("System default"),
        PROFILE("AWS profile");

        private final String title;

        private ConfigType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

