/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.conversions;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.conversions.ISqlConverter;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.ExactNumConverter;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SqlExactNumberConverter
implements ISqlConverter {
    private final short m_tgtType;
    private final short m_tgtPrecision;
    private final short m_tgtScale;
    private final long m_targetColLen;
    private final boolean m_targetIsSigned;

    public SqlExactNumberConverter(IColumn iColumn, IColumn iColumn2) {
        assert (iColumn.getTypeMetadata().isExactNumericType());
        TypeMetadata typeMetadata = iColumn2.getTypeMetadata();
        this.m_tgtType = typeMetadata.getType();
        this.m_tgtPrecision = typeMetadata.getPrecision();
        this.m_tgtScale = typeMetadata.getScale();
        this.m_targetColLen = iColumn2.getColumnLength();
        this.m_targetIsSigned = typeMetadata.isSigned();
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
        if (null == bigDecimal) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return conversionResult;
        }
        switch (this.m_tgtType) {
            case 2: 
            case 3: {
                BigDecimal bigDecimal2 = ExactNumConverter.setPrecScale(bigDecimal, this.m_tgtPrecision, this.m_tgtScale, conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal2);
                break;
            }
            case 6: 
            case 8: {
                double d = ExactNumConverter.toDouble(bigDecimal, conversionResult);
                iSqlDataWrapper2.setDouble(d);
                break;
            }
            case -7: 
            case 16: {
                boolean bl = ExactNumConverter.toBoolean(bigDecimal, conversionResult);
                iSqlDataWrapper2.setBoolean(bl);
                break;
            }
            case 7: {
                float f = ExactNumConverter.toFloat(bigDecimal, conversionResult);
                iSqlDataWrapper2.setReal(f);
                break;
            }
            case -5: {
                BigInteger bigInteger = ExactNumConverter.toBigInt(bigDecimal, this.m_targetIsSigned, conversionResult);
                iSqlDataWrapper2.setBigInt(bigInteger);
                break;
            }
            case 4: {
                long l = ExactNumConverter.toInteger(bigDecimal, this.m_targetIsSigned, conversionResult);
                iSqlDataWrapper2.setInteger(l);
                break;
            }
            case 5: {
                int n = ExactNumConverter.toSmallInt(bigDecimal, this.m_targetIsSigned, conversionResult);
                iSqlDataWrapper2.setSmallInt(n);
                break;
            }
            case -6: {
                short s = ExactNumConverter.toTinyInt(bigDecimal, this.m_targetIsSigned, conversionResult);
                iSqlDataWrapper2.setTinyInt(s);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = ExactNumConverter.toChar(iSqlDataWrapper.getExactNumber(), this.m_targetColLen, conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_tgtType));
            }
        }
        return conversionResult;
    }
}

