/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.httpclient.log.IamCustomLogFactory;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class SamlCredentialsProvider
implements IPlugin {
    protected static final String KEY_IDP_HOST = "idp_host";
    private static final String KEY_IDP_PORT = "idp_port";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_PREFERRED_ROLE = "preferred_role";
    private static final String KEY_SSL_INSECURE = "ssl_insecure";
    protected String m_userName;
    protected String m_password;
    protected String m_idpHost;
    protected int m_idpPort = 443;
    protected int m_duration;
    protected String m_preferredRole;
    protected boolean m_sslInsecure;
    protected String m_dbUser;
    protected String m_dbGroups;
    protected Boolean m_forceLowercase;
    protected Boolean m_autoCreate;
    protected String m_region;
    protected ILogger m_log;
    private static Map<String, CredentialsHolder> m_cache = new HashMap<String, CredentialsHolder>();
    private static final Class<?> CUSTOM_LOG_FACTORY_CLASS = IamCustomLogFactory.class;
    private static final String LOG_PROPERTIES_FILE_NAME = "log-factory.properties";
    private static final String LOG_PROPERTIES_FILE_PATH = "META-INF/services/org.apache.commons.logging.LogFactory";
    private static final ClassLoader CONTEXT_CLASS_LOADER = new ClassLoader(SamlCredentialsProvider.class.getClassLoader()){

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            Class<?> clazz = this.getParent().loadClass(string);
            if (LogFactory.class.isAssignableFrom(clazz)) {
                return CUSTOM_LOG_FACTORY_CLASS;
            }
            return clazz;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if ("commons-logging.properties".equals(string)) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(string);
        }

        @Override
        public URL getResource(String string) {
            if (SamlCredentialsProvider.LOG_PROPERTIES_FILE_PATH.equals(string)) {
                return SamlCredentialsProvider.class.getResource(SamlCredentialsProvider.LOG_PROPERTIES_FILE_NAME);
            }
            return super.getResource(string);
        }
    };

    protected abstract String getSamlAssertion() throws IOException;

    @Override
    public void addParameter(String string, String string2) {
        if ("UID".equalsIgnoreCase(string) || "user".equalsIgnoreCase(string)) {
            this.m_userName = string2;
        } else if ("PWD".equalsIgnoreCase(string) || "password".equalsIgnoreCase(string)) {
            this.m_password = string2;
        } else if (KEY_IDP_HOST.equalsIgnoreCase(string)) {
            this.m_idpHost = string2;
        } else if (KEY_IDP_PORT.equalsIgnoreCase(string)) {
            this.m_idpPort = Integer.parseInt(string2);
        } else if (KEY_DURATION.equalsIgnoreCase(string)) {
            this.m_duration = Integer.parseInt(string2);
        } else if (KEY_PREFERRED_ROLE.equalsIgnoreCase(string)) {
            this.m_preferredRole = string2;
        } else if (KEY_SSL_INSECURE.equalsIgnoreCase(string)) {
            this.m_sslInsecure = Boolean.parseBoolean(string2);
        } else if ("DbUser".equalsIgnoreCase(string)) {
            this.m_dbUser = string2;
        } else if ("DbGroups".equalsIgnoreCase(string)) {
            this.m_dbGroups = string2;
        } else if ("ForceLowercase".equalsIgnoreCase(string)) {
            this.m_forceLowercase = Boolean.valueOf(string2);
        } else if ("AutoCreate".equalsIgnoreCase(string)) {
            this.m_autoCreate = Boolean.valueOf(string2);
        } else if ("Region".equalsIgnoreCase(string)) {
            this.m_region = string2;
        }
    }

    @Override
    public void setILogger(ILogger iLogger) {
        this.m_log = iLogger;
    }

    @Override
    public CredentialsHolder getCredentials() {
        String string = this.getCacheKey();
        CredentialsHolder credentialsHolder = m_cache.get(string);
        if (credentialsHolder == null || credentialsHolder.isExpired()) {
            this.refresh();
        }
        credentialsHolder = m_cache.get(string);
        if (!StringUtils.isNullOrEmpty(this.m_dbUser)) {
            credentialsHolder.getThisMetadata().setDbUser(this.m_dbUser);
        }
        if (credentialsHolder == null) {
            throw new SdkClientException("Unable to load AWS credentials from ADFS");
        }
        return credentialsHolder;
    }

    @Override
    public void refresh() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            String string;
            Object object;
            Object object22;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Pattern pattern = Pattern.compile("arn:aws:iam::\\d*:saml-provider/\\S+");
            Pattern pattern2 = Pattern.compile("arn:aws:iam::\\d*:role/\\S+");
            String string2 = this.getSamlAssertion();
            LogUtilities.logTrace(String.format("SAML assertion: %s", string2), this.m_log);
            Document document = SamlCredentialsProvider.parse(Base64.decodeBase64((String)string2));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string3 = "//*[local-name()='Attribute'][@Name='https://aws.amazon.com/SAML/Attributes/Role']/*[local-name()='AttributeValue']/text()";
            NodeList nodeList = (NodeList)xPath.compile(string3).evaluate(document, XPathConstants.NODESET);
            HashMap<AWSSecurityTokenService, AWSSecurityTokenServiceClientBuilder> hashMap = new HashMap<AWSSecurityTokenService, AWSSecurityTokenServiceClientBuilder>();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object7 = nodeList.item(i);
                    object6 = object7.getNodeValue();
                    object5 = ((String)object6).split(",");
                    if (((String[])object5).length < 2) continue;
                    object4 = null;
                    object3 = null;
                    for (Object object22 : object5) {
                        object = pattern.matcher((CharSequence)object22);
                        if (((Matcher)object).find()) {
                            object4 = ((Matcher)object).group(0);
                            continue;
                        }
                        Matcher matcher = pattern2.matcher((CharSequence)object22);
                        if (!matcher.find()) continue;
                        object3 = matcher.group(0);
                    }
                    if (StringUtils.isNullOrEmpty(object3) || StringUtils.isNullOrEmpty(object4)) continue;
                    hashMap.put((AWSSecurityTokenService)object3, (AWSSecurityTokenServiceClientBuilder)object4);
                }
            }
            if (hashMap.isEmpty()) {
                throw new SdkClientException("No role found in SamlAssertion: " + string2);
            }
            if (this.m_preferredRole != null) {
                string = this.m_preferredRole;
                object7 = (String)hashMap.get(this.m_preferredRole);
                if (object7 == null) {
                    throw new SdkClientException("Preferred role not found in SamlAssertion: " + string2);
                }
            } else {
                object6 = hashMap.entrySet().iterator().next();
                string = (String)object6.getKey();
                object7 = (String)object6.getValue();
            }
            object6 = new AssumeRoleWithSAMLRequest();
            object6.setSAMLAssertion(string2);
            object6.setRoleArn(string);
            object6.setPrincipalArn((String)object7);
            if (this.m_duration > 0) {
                object6.setDurationSeconds(Integer.valueOf(this.m_duration));
            }
            object5 = new AWSStaticCredentialsProvider(new AnonymousAWSCredentials());
            object4 = AWSSecurityTokenServiceClientBuilder.standard();
            object4.setRegion(this.m_region);
            object3 = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)object4.withCredentials((AWSCredentialsProvider)object5)).build();
            AssumeRoleWithSAMLResult assumeRoleWithSAMLResult = object3.assumeRoleWithSAML((AssumeRoleWithSAMLRequest)object6);
            Credentials credentials = assumeRoleWithSAMLResult.getCredentials();
            Date date = credentials.getExpiration();
            object22 = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
            object = CredentialsHolder.newInstance((AWSCredentials)object22, date);
            ((CredentialsHolder)object).setMetadata(this.readMetadata(document));
            m_cache.put(this.getCacheKey(), (CredentialsHolder)object);
        }
        catch (IOException iOException) {
            throw new SdkClientException("SAML error: " + iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            throw new SdkClientException("SAML error: " + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SdkClientException("SAML error: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new SdkClientException("SAML error: " + xPathExpressionException.getMessage(), xPathExpressionException);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private String getCacheKey() {
        return this.m_userName + this.m_password + this.m_idpHost + this.m_idpPort + this.m_duration + this.m_preferredRole;
    }

    private CredentialsHolder.IamMetadata readMetadata(Document document) throws XPathExpressionException {
        CredentialsHolder.IamMetadata iamMetadata = new CredentialsHolder.IamMetadata();
        XPath xPath = XPathFactory.newInstance().newXPath();
        List<String> list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/AllowDbUserOverride");
        if (!list.isEmpty()) {
            iamMetadata.setAllowDbUserOverride(Boolean.valueOf(list.get(0)));
        }
        if (!(list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/DbUser")).isEmpty()) {
            iamMetadata.setSamlDbUser(list.get(0));
        } else {
            list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://aws.amazon.com/SAML/Attributes/RoleSessionName");
            if (!list.isEmpty()) {
                iamMetadata.setSamlDbUser(list.get(0));
            }
        }
        list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/AutoCreate");
        if (!list.isEmpty()) {
            iamMetadata.setAutoCreate(Boolean.valueOf(list.get(0)));
        }
        if (!(list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/DbGroups")).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
            iamMetadata.setDbGroups(stringBuilder.toString());
        }
        if (!(list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/ForceLowercase")).isEmpty()) {
            iamMetadata.setForceLowercase(Boolean.valueOf(list.get(0)));
        }
        return iamMetadata;
    }

    private static Document parse(byte[] byArray) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(byArray));
    }

    private static List<String> GetSAMLAttributeValues(XPath xPath, Document document, String string) throws XPathExpressionException {
        String string2 = String.format("//Attribute[@Name='%s']/AttributeValue/text()", string);
        NodeList nodeList = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
        if (null == nodeList || nodeList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            arrayList.add(node.getNodeValue());
        }
        return arrayList;
    }

    protected CloseableHttpClient getHttpClient() throws GeneralSecurityException {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setExpectContinueEnabled(false).setCookieSpec("standard").build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        if (this.m_sslInsecure) {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            TrustManager[] trustManagerArray = new TrustManager[]{new NonValidatingFactory()};
            sSLContext.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLSocketFactory, (HostnameVerifier)new NoopHostnameVerifier());
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sSLConnectionSocketFactory);
        }
        return httpClientBuilder.build();
    }

    protected List<String> getInputTagsfromHTML(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<input(.+?)/>", 32);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            String string3 = this.getValueByKey(string2, "name").toLowerCase();
            if (string3.isEmpty() || !hashSet.add(string3)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected String getFormAction(String string) {
        Pattern pattern = Pattern.compile("<form.*?action=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return this.escapeHtmlEntity(matcher.group(1));
        }
        return null;
    }

    protected String getValueByKey(String string, String string2) {
        Pattern pattern = Pattern.compile("(" + Pattern.quote(string2) + ")\\s*=\\s*\"(.*?)\"");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return this.escapeHtmlEntity(matcher.group(2));
        }
        return "";
    }

    protected boolean isText(String string) {
        return "text".equals(this.getValueByKey(string, "type"));
    }

    protected boolean isPassword(String string) {
        return "password".equals(this.getValueByKey(string, "type"));
    }

    protected String escapeHtmlEntity(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '&') {
                stringBuilder.append(c);
                ++n;
                continue;
            }
            if (string.startsWith("&amp;", n)) {
                stringBuilder.append('&');
                n += 5;
                continue;
            }
            if (string.startsWith("&apos;", n)) {
                stringBuilder.append('\'');
                n += 6;
                continue;
            }
            if (string.startsWith("&quot;", n)) {
                stringBuilder.append('\"');
                n += 6;
                continue;
            }
            if (string.startsWith("&lt;", n)) {
                stringBuilder.append('<');
                n += 4;
                continue;
            }
            if (string.startsWith("&gt;", n)) {
                stringBuilder.append('>');
                n += 4;
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    protected void checkRequiredParameters() throws IOException {
        if (StringUtils.isNullOrEmpty(this.m_userName)) {
            throw new IOException("Missing required property: user");
        }
        if (StringUtils.isNullOrEmpty(this.m_password)) {
            throw new IOException("Missing required property: password");
        }
        if (StringUtils.isNullOrEmpty(this.m_idpHost)) {
            throw new IOException("Missing required property: idp_host");
        }
    }
}

