/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class OktaCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_APP_URL = "app_id";
    private static final String KEY_APP_NAME = "app_name";
    protected String m_app_id;
    protected String m_app_name;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_APP_URL.equalsIgnoreCase(string)) {
            this.m_app_id = string2;
        }
        if (KEY_APP_NAME.equalsIgnoreCase(string)) {
            this.m_app_name = string2;
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        if (StringUtils.isNullOrEmpty(this.m_app_id)) {
            throw new IOException("Missing required property: app_id");
        }
        CloseableHttpClient closeableHttpClient = null;
        try {
            closeableHttpClient = this.getHttpClient();
            String string = this.oktaAuthentication(closeableHttpClient);
            String string2 = this.handleSamlAssertion(closeableHttpClient, string);
            return string2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly((Closeable)closeableHttpClient, null);
        }
    }

    private String oktaAuthentication(CloseableHttpClient closeableHttpClient) throws IOException {
        block4: {
            String string;
            CloseableHttpResponse closeableHttpResponse = null;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                HttpPost httpPost = new HttpPost("https://" + this.m_idpHost + "/api/v1/authn");
                httpPost.addHeader("Accept", "application/json");
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.addHeader("Cache-Control", "no-cache");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("username", this.m_userName);
                hashMap.put("password", this.m_password);
                StringWriter stringWriter = new StringWriter();
                objectMapper.writeValue((Writer)stringWriter, hashMap);
                StringEntity stringEntity = new StringEntity(stringWriter.toString(), "UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
                closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                int n = statusLine.getStatusCode();
                if (n != 200) {
                    throw new IOException(statusLine.getReasonPhrase());
                }
                JsonNode jsonNode = objectMapper.readTree(EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()));
                if (!"SUCCESS".equals(jsonNode.get("status").asText())) break block4;
                string = jsonNode.get("sessionToken").asText();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)closeableHttpResponse, null);
            return string;
        }
        throw new IOException("No session token in the response.");
    }

    private String handleSamlAssertion(CloseableHttpClient closeableHttpClient, String string) throws IOException {
        this.m_app_name = StringUtils.isNullOrEmpty(this.m_app_name) ? "amazon_aws" : URLEncoder.encode(this.m_app_name, "UTF-8");
        String string2 = "https://" + this.m_idpHost + "/home/" + this.m_app_name + "/" + this.m_app_id;
        HttpGet httpGet = new HttpGet(string2 + "?onetimetoken=" + string);
        CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
        int n = closeableHttpResponse.getStatusLine().getStatusCode();
        if (n != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + closeableHttpResponse.getStatusLine().getStatusCode() + " : Reason : " + closeableHttpResponse.getStatusLine().getReasonPhrase());
        }
        String string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
        for (String string4 : this.getInputTagsfromHTML(string3)) {
            String string5 = this.getValueByKey(string4, "name");
            String string6 = this.getValueByKey(string4, "value");
            if (!"SAMLResponse".equalsIgnoreCase(string5)) continue;
            return string6.replace("&#x2b;", "+").replace("&#x3d;", "=");
        }
        throw new IOException("Failed to retrieve SAMLAssertion.");
    }
}

