/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.DoubleClickList;
import com.ibm.as400.vaccess.LabelledComponent;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLQueryClause;
import com.ibm.as400.vaccess.SQLQueryFieldsPane;
import com.ibm.as400.vaccess.ScrollingTextPane;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

class SQLQueryJoinPane
extends SQLQueryFieldsPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int INNER_JOIN = 1;
    public static final int OUTER_JOIN = 2;
    private ButtonGroup joinButtonGroup_;
    private JPanel joinButtonPanel_;
    private DefaultListModel tableListModel_;
    DoubleClickList tableList_;
    DoubleClickList testList_;
    DoubleClickList otherList_;
    JRadioButton innerJoinButton_;
    private JRadioButton outerJoinButton_;
    private SQLQueryClause clause_;
    private boolean secondField_ = false;
    private Vector clauses_ = new Vector();
    int current_ = 0;
    int currentTable_ = 0;
    private Vector locationInClause_ = new Vector();
    static final String[] testChoices = new String[]{"=", "<>", "<", ">", "<=", ">="};
    static final String[] otherChoices = new String[]{"AND"};

    public SQLQueryJoinPane(SQLQueryBuilderPane sQLQueryBuilderPane) {
        super(sQLQueryBuilderPane);
    }

    private void buildTableList() {
        String[] stringArray = this.parent_.getTables();
        int n = stringArray.length - 1;
        this.tableListModel_.removeAllElements();
        if (n > 0) {
            this.tableListModel_.addElement(stringArray[0] + " + " + stringArray[1]);
        }
        for (int i = 1; i < n; ++i) {
            this.tableListModel_.addElement("+ " + stringArray[i + 1]);
        }
        while (this.clauses_.size() < n) {
            this.clauses_.addElement("");
            this.locationInClause_.addElement(new Integer(1));
        }
    }

    public void complete() {
        if (this.clauses_.size() > 0) {
            this.clauses_.setElementAt(this.clause_.getText(), this.current_);
        }
    }

    public String getClause(int n) {
        if (this.clause_ == null || this.clauses_.size() == 0) {
            return null;
        }
        return (String)this.clauses_.elementAt(n);
    }

    public int getJoinType() {
        if (this.joinButtonGroup_ == null) {
            return 1;
        }
        ButtonModel buttonModel = this.joinButtonGroup_.getSelection();
        if (buttonModel == this.innerJoinButton_.getModel()) {
            return 1;
        }
        return 2;
    }

    void otherPicked(String string) {
        this.clause_.appendText(string);
        this.otherList_.setEnabled(false);
        this.fields_.setEnabled(true);
        this.locationInClause_.setElementAt(new Integer(1), this.current_);
    }

    protected void rowPicked(int n) {
        if ((Integer)this.locationInClause_.elementAt(this.current_) == 1) {
            this.clause_.appendText("(" + this.fieldName(n));
            this.testList_.setEnabled(true);
            this.locationInClause_.setElementAt(new Integer(2), this.current_);
        } else {
            this.clause_.appendText(this.fieldName(n) + ")");
            this.otherList_.setEnabled(true);
            this.locationInClause_.setElementAt(new Integer(4), this.current_);
        }
        this.fields_.setEnabled(false);
    }

    protected void setupPane() {
        super.setupPane();
        JoinListener_ joinListener_ = new JoinListener_();
        this.outerJoinButton_ = new JRadioButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_OUTER_JOIN"), false);
        this.outerJoinButton_.setName("joinOuterButton");
        this.outerJoinButton_.addActionListener(joinListener_);
        this.innerJoinButton_ = new JRadioButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_INNER_JOIN"), true);
        this.innerJoinButton_.setName("joinInnerButton");
        this.innerJoinButton_.addActionListener(joinListener_);
        this.joinButtonGroup_ = new ButtonGroup();
        this.joinButtonGroup_.add(this.innerJoinButton_);
        this.joinButtonGroup_.add(this.outerJoinButton_);
        Box box = Box.createVerticalBox();
        box.add(this.innerJoinButton_);
        box.add(this.outerJoinButton_);
        this.joinButtonPanel_ = new JPanel();
        this.joinButtonPanel_.setLayout(new BorderLayout());
        this.joinButtonPanel_.setBorder(new TitledBorder(ResourceLoader.getQueryText("DBQUERY_LABEL_JOIN_TYPE")));
        this.joinButtonPanel_.add("Center", box);
        this.tableListModel_ = new DefaultListModel();
        this.buildTableList();
        this.tableList_ = new DoubleClickList(this.tableListModel_);
        this.tableList_.setVisibleRowCount(3);
        this.tableList_.setSelectedIndex(this.current_);
        this.tableList_.setEnabled(false);
        this.tableList_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SQLQueryJoinPane.this.tablePicked(SQLQueryJoinPane.this.tableList_.getSelectedIndex());
            }
        });
        Box box2 = Box.createHorizontalBox();
        box2.add(this.joinButtonPanel_);
        box2.add(new LabelledComponent("DBQUERY_LABEL_TABLES", this.tableList_));
        this.testList_ = new DoubleClickList(testChoices);
        this.testList_.setEnabled(false);
        this.testList_.setVisibleRowCount(6);
        this.testList_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SQLQueryJoinPane.this.testPicked((String)itemEvent.getItem());
            }
        });
        this.otherList_ = new DoubleClickList(otherChoices);
        this.otherList_.setEnabled(false);
        this.otherList_.setVisibleRowCount(6);
        this.otherList_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SQLQueryJoinPane.this.otherPicked((String)itemEvent.getItem());
            }
        });
        Box box3 = Box.createHorizontalBox();
        box3.add(new LabelledComponent("DBQUERY_LABEL_TEST", this.testList_));
        box3.add(new LabelledComponent("DBQUERY_LABEL_OTHER", this.otherList_));
        this.clause_ = new SQLQueryClause(5);
        Box box4 = Box.createVerticalBox();
        box4.add(box2);
        box4.add(this.fields_);
        box4.add(box3);
        box4.add(new LabelledComponent("DBQUERY_LABEL_CLAUSE_JOIN", new ScrollingTextPane(this.clause_)));
        this.setLayout(new BorderLayout());
        this.add("Center", box4);
    }

    void tablePicked(int n) {
        this.complete();
        this.clause_.setText((String)this.clauses_.elementAt(n));
        this.current_ = n;
        switch ((Integer)this.locationInClause_.elementAt(n)) {
            case 1: 
            case 3: {
                this.fields_.setEnabled(true);
                this.testList_.setEnabled(false);
                this.otherList_.setEnabled(false);
                break;
            }
            case 2: {
                this.fields_.setEnabled(false);
                this.testList_.setEnabled(true);
                this.otherList_.setEnabled(false);
                break;
            }
            case 4: {
                this.fields_.setEnabled(false);
                this.testList_.setEnabled(false);
                this.otherList_.setEnabled(true);
            }
        }
    }

    void testPicked(String string) {
        this.clause_.appendText(string);
        this.testList_.setEnabled(false);
        this.fields_.setEnabled(true);
        this.locationInClause_.setElementAt(new Integer(3), this.current_);
    }

    public void update() {
        boolean bl = this.fieldsChanged_;
        super.update();
        if (bl) {
            this.buildTableList();
            if (this.currentTable_ > this.parent_.getTables().length - 1) {
                this.currentTable_ = 0;
                if (this.getJoinType() == 2) {
                    this.current_ = this.currentTable_;
                }
            }
            this.tableList_.setSelectedIndex(this.current_);
        }
    }

    private class JoinListener_
    implements ActionListener {
        private JoinListener_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SQLQueryJoinPane.this.innerJoinButton_) {
                if (SQLQueryJoinPane.this.tableList_.isEnabled()) {
                    SQLQueryJoinPane.this.tableList_.setEnabled(false);
                    SQLQueryJoinPane.this.tablePicked(0);
                }
            } else {
                SQLQueryJoinPane.this.tableList_.setEnabled(true);
                SQLQueryJoinPane.this.tablePicked(SQLQueryJoinPane.this.currentTable_);
            }
        }
    }
}

