/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.SystemResourceFinder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class XMLErrorHandler
implements ErrorHandler {
    private String m_filename;
    private int m_headerLineCount;
    private boolean m_ignorePCML = false;
    private ParseException m_exc;

    public XMLErrorHandler(String string, int n) {
        this.m_filename = string;
        this.m_headerLineCount = n;
    }

    public void error(SAXParseException sAXParseException) {
        String string;
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (n - this.m_headerLineCount <= 0) {
            string = "pcml.dtd";
            this.m_ignorePCML = true;
        } else {
            if (this.m_ignorePCML) {
                return;
            }
            string = this.m_filename;
            n -= this.m_headerLineCount;
        }
        if (this.m_exc == null) {
            this.m_exc = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{string}));
        }
        this.m_exc.addMessage("[" + n + "," + (n2 - 1) + "]: " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.error(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        String string;
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (n - this.m_headerLineCount <= 0) {
            string = "pcml.dtd";
        } else {
            string = this.m_filename;
            n -= this.m_headerLineCount;
        }
        System.err.println(string + "[" + n + "," + (n2 - 1) + "]: " + sAXParseException.getMessage());
    }

    public ParseException getException() {
        return this.m_exc;
    }
}

