/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBVariableData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLArray;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.sql.SQLException;
import java.util.Hashtable;

class JDServerRow
implements JDRow {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int[] parameterTypes_;
    private AS400JDBCConnection connection_;
    private int[] ccsids_;
    private int[] dataLength_;
    private int[] arrayDataLength_;
    private int[] dataOffset_;
    private String[] fieldNames_;
    private int[] lobLocatorHandles_;
    private int[] precisions_;
    private byte[] rawBytes_;
    private int rowDataOffset_;
    private int rowIndex_;
    private int[] scales_;
    private DBData serverData_;
    private DBDataFormat serverFormat_;
    private SQLData[] sqlData_;
    private int[] sqlTypes_;
    private boolean[] translated_;
    private boolean wasCompressed = false;
    private Hashtable insensitiveColumnNames_;
    boolean containsLob_;
    boolean containsArray_;

    JDServerRow(AS400JDBCConnection aS400JDBCConnection, int n, DBDataFormat dBDataFormat, SQLConversionSettings sQLConversionSettings) throws SQLException {
        this.initialize(aS400JDBCConnection, n, dBDataFormat, sQLConversionSettings);
    }

    byte[] getRawBytes(int n) {
        int n2 = n - 1;
        byte[] byArray = new byte[this.dataLength_[n2]];
        System.arraycopy(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[n2], byArray, 0, this.dataLength_[n2]);
        return byArray;
    }

    private void initialize(AS400JDBCConnection aS400JDBCConnection, int n, DBDataFormat dBDataFormat, SQLConversionSettings sQLConversionSettings) throws SQLException {
        this.connection_ = aS400JDBCConnection;
        this.rawBytes_ = null;
        this.rowDataOffset_ = -1;
        this.rowIndex_ = -1;
        this.serverData_ = null;
        this.serverFormat_ = dBDataFormat;
        int n2 = -1;
        int n3 = -1;
        try {
            int n4 = this.serverFormat_ == null ? 0 : this.serverFormat_.getNumberOfFields();
            this.ccsids_ = new int[n4];
            this.dataLength_ = new int[n4];
            this.arrayDataLength_ = new int[n4];
            this.dataOffset_ = new int[n4];
            this.fieldNames_ = new String[n4];
            this.lobLocatorHandles_ = new int[n4];
            this.precisions_ = new int[n4];
            this.scales_ = new int[n4];
            this.sqlData_ = new SQLData[n4];
            this.sqlTypes_ = new int[n4];
            this.translated_ = new boolean[n4];
            this.insensitiveColumnNames_ = null;
            this.containsLob_ = false;
            this.containsArray_ = false;
            if (n4 > 0) {
                int n5 = 0;
                boolean bl = aS400JDBCConnection.getProperties().getBoolean(28);
                if (this.connection_.getVRM() >= JDUtilities.vrm610 && this.serverFormat_.getCSRSData()) {
                    n2 = this.serverFormat_.getDateFormat();
                    n3 = this.serverFormat_.getTimeFormat();
                }
                for (int i = 0; i < n4; ++i) {
                    this.ccsids_[i] = this.serverFormat_.getFieldCCSID(i);
                    this.dataOffset_[i] = n5;
                    this.dataLength_[i] = this.serverFormat_.getFieldLength(i);
                    this.lobLocatorHandles_[i] = this.serverFormat_.getFieldLOBLocator(i);
                    n5 += this.dataLength_[i];
                    this.scales_[i] = this.serverFormat_.getFieldScale(i);
                    this.precisions_[i] = this.serverFormat_.getFieldPrecision(i);
                    this.sqlTypes_[i] = this.serverFormat_.getFieldSQLType(i);
                    int n6 = -1;
                    if (this.serverFormat_.getArrayType(i) == 1) {
                        n6 = this.sqlTypes_[i] & 0xFFFE;
                        this.sqlTypes_[i] = 10000;
                        this.arrayDataLength_[i] = this.serverFormat_.getArrayFieldLength(i);
                    } else {
                        this.arrayDataLength_[i] = 0;
                    }
                    int n7 = this.sqlTypes_[i] & 0xFFFE;
                    if (n7 == 404 || n7 == 960 || n7 == 408 || n7 == 964 || n7 == 412 || n7 == 968) {
                        this.containsLob_ = true;
                    } else if (n7 == 10000) {
                        this.containsArray_ = true;
                    }
                    int n8 = this.serverFormat_.getFieldLOBMaxSize(i);
                    int n9 = this.serverFormat_.getXMLCharType(i);
                    this.sqlData_[i] = n7 == 10000 ? SQLDataFactory.newData(aS400JDBCConnection, n, n7, this.arrayDataLength_[i], this.precisions_[i], this.scales_[i], this.ccsids_[i], bl, sQLConversionSettings, n8, i + 1, n2, n3, n6, n9) : SQLDataFactory.newData(aS400JDBCConnection, n, n7, this.dataLength_[i], this.precisions_[i], this.scales_[i], this.ccsids_[i], bl, sQLConversionSettings, n8, i + 1, n2, n3, n6, n9);
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
    }

    void setOriginalData() throws SQLException {
        try {
            int n = 0;
            if (this.serverFormat_ != null) {
                n = this.serverFormat_.getNumberOfFields();
            }
            if (n > 0) {
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    this.dataOffset_[i] = n2;
                    this.dataLength_[i] = this.serverFormat_.getFieldLength(i);
                    this.arrayDataLength_[i] = this.serverFormat_.getArrayFieldLength(i);
                    n2 += this.dataLength_[i];
                }
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
    }

    void setServerData(DBData dBData) throws SQLException {
        this.serverData_ = dBData;
        try {
            this.rawBytes_ = this.serverData_.getRawBytes();
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
    }

    void setRowIndex(int n) throws SQLException {
        this.rowIndex_ = n;
        try {
            if (this.serverData_ != null) {
                int n2;
                Object object;
                int n3;
                int n4;
                this.rowDataOffset_ = this.serverData_.getRowDataOffset(this.rowIndex_);
                if (this.containsArray_ && this.rowDataOffset_ != -1) {
                    n4 = 0;
                    n3 = this.serverFormat_.getNumberOfFields();
                    int[] nArray = ((DBVariableData)this.serverData_).getTotalDataLengthsFromHost();
                    object = ((DBVariableData)this.serverData_).getArrayDataLengthsFromHost();
                    n2 = 0;
                    for (int i = 0; i < n3; ++i) {
                        if (!this.isOutput(i + 1)) continue;
                        int n5 = 0;
                        this.dataOffset_[i] = n4;
                        n5 = nArray[n2];
                        n4 += n5;
                        this.dataLength_[i] = n5;
                        if (object[n2] > 0) {
                            this.arrayDataLength_[i] = (int)object[n2];
                        }
                        ++n2;
                    }
                } else if (this.serverData_.isVariableFieldsCompressed() && this.rowDataOffset_ != -1) {
                    this.wasCompressed = true;
                    n4 = 0;
                    n3 = this.serverFormat_.getNumberOfFields();
                    for (int i = 0; i < n3; ++i) {
                        object = this.sqlData_[i].getTypeName();
                        n2 = 0;
                        this.dataOffset_[i] = n4;
                        if (((String)object).equals("VARCHAR") || ((String)object).equals("VARCHAR() FOR BIT DATA") || ((String)object).equals("LONG VARCHAR") || ((String)object).equals("LONG VARCHAR FOR BIT DATA") || ((String)object).equals("VARBINARY") || ((String)object).equals("DATALINK")) {
                            n2 = BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.rowDataOffset_ + n4);
                            n2 += 2;
                        } else if (((String)object).equals("VARGRAPHIC") || ((String)object).equals("LONG VARGRAPHIC") || ((String)object).equals("NVARCHAR")) {
                            n2 = 2 * BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.rowDataOffset_ + n4);
                            n2 += 2;
                        } else {
                            n2 = this.serverFormat_.getFieldLength(i);
                        }
                        n4 += n2;
                        this.dataLength_[i] = n2;
                        this.arrayDataLength_[i] = this.serverFormat_.getArrayFieldLength(i);
                    }
                } else if (this.wasCompressed) {
                    this.wasCompressed = false;
                    this.setOriginalData();
                }
            } else {
                this.rowDataOffset_ = -1;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        for (int i = 0; i < this.translated_.length; ++i) {
            this.translated_[i] = false;
        }
    }

    public int findField(String string) throws SQLException {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = JDUtilities.stripOuterDoubleQuotes(string);
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                if (!string.equals(this.getFieldName(i))) continue;
                return i;
            }
        } else {
            Integer n;
            String string2;
            if (this.insensitiveColumnNames_ == null) {
                this.insensitiveColumnNames_ = new Hashtable(this.sqlData_.length);
                for (int i = this.sqlData_.length; i >= 1; --i) {
                    string2 = this.getFieldName(i);
                    this.insensitiveColumnNames_.put(string2, new Integer(i));
                }
            }
            if ((n = (Integer)this.insensitiveColumnNames_.get(string)) != null) {
                return n;
            }
            string2 = string.toUpperCase();
            n = (Integer)this.insensitiveColumnNames_.get(string2);
            if (n != null) {
                this.insensitiveColumnNames_.put(string, n);
                return n;
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Did not find column " + string);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                stringBuffer.append("[" + i + "]=" + this.getFieldName(i) + " ");
            }
            JDTrace.logInformation(this, "Columns are " + stringBuffer.toString());
        }
        JDError.throwSQLException("42703");
        return -1;
    }

    public int getFieldCount() {
        return this.sqlData_.length;
    }

    public int getFieldLOBLocatorHandle(int n) throws SQLException {
        return this.lobLocatorHandles_[n - 1];
    }

    public String getFieldName(int n) throws SQLException {
        try {
            boolean bl;
            int n2 = n - 1;
            if (this.fieldNames_[n2] == null) {
                this.fieldNames_[n2] = this.serverFormat_.getFieldName(n2, this.connection_.getConverter(this.serverFormat_.getFieldNameCCSID(n2))).trim();
            }
            if (bl = this.connection_.getProperties().getBoolean(60)) {
                String string = this.fieldNames_[n2];
                string = AS400BidiTransform.convertDataFromHostCCSID(string, this.connection_, this.serverFormat_.getFieldNameCCSID(n2));
                return string;
            }
            return this.fieldNames_[n2];
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return null;
        }
    }

    public SQLData getSQLData(int n) throws SQLException {
        try {
            int n2 = n - 1;
            if (this.rowIndex_ >= 0 && !this.translated_[n2]) {
                ConvTable convTable = this.connection_.getConverter(this.ccsids_[n2]);
                if (this.rawBytes_ != null) {
                    if (this.sqlData_[n2].getType() == 2003) {
                        int n3 = this.getVariableOutputIndex(n2);
                        int n4 = ((DBVariableData)this.serverData_).getIndicatorCountsFromHost()[n3];
                        ((SQLArray)this.sqlData_[n2]).setArrayCount(n4);
                        this.sqlData_[n2].convertFromRawBytes(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[n2], convTable);
                        for (int i = 0; i < n4; ++i) {
                            if (this.serverData_ == null || this.serverData_.getIndicator(this.rowIndex_, n3, i) != -1) continue;
                            ((SQLArray)this.sqlData_[n2]).setElementNull(i);
                        }
                    } else {
                        this.sqlData_[n2].convertFromRawBytes(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[n2], convTable);
                    }
                    this.translated_[n2] = true;
                }
            }
            return this.sqlData_[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return null;
        }
    }

    int getVariableOutputIndex(int n) throws SQLException {
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            if (!this.isOutput(i + 1)) continue;
            ++n2;
        }
        return n2 - 1;
    }

    public SQLData getSQLType(int n) throws SQLException {
        return this.sqlData_[n - 1];
    }

    public boolean isDataMappingError(int n) throws SQLException {
        try {
            int n2 = n;
            if (this.serverData_ instanceof DBVariableData) {
                n2 = this.getVariableOutputIndex(n - 1) + 1;
            }
            return this.serverData_ != null && this.serverData_.getIndicator(this.rowIndex_, n2 - 1) == -2;
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return false;
        }
    }

    public boolean isNull(int n) throws SQLException {
        try {
            int n2 = n;
            if (this.serverData_ instanceof DBVariableData) {
                n2 = this.getVariableOutputIndex(n - 1) + 1;
            }
            return this.serverData_ != null && this.serverData_.getIndicator(this.rowIndex_, n2 - 1) == -1;
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return false;
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            return (this.sqlTypes_[n - 1] & 1) != 0 ? 1 : 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JDError.throwSQLException("07009", arrayIndexOutOfBoundsException);
            return 0;
        }
    }

    public int getCCSID(int n) throws SQLException {
        return this.ccsids_[n - 1];
    }

    public int getLength(int n) throws SQLException {
        return this.dataLength_[n - 1];
    }

    public int getArrayDataLength(int n) {
        return this.arrayDataLength_[n - 1];
    }

    int getRowLength() throws SQLException {
        try {
            return this.serverFormat_.getRecordSize();
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("07009", dBDataStreamException);
            return -1;
        }
    }

    private synchronized void initParmTypes() {
        int n = this.getFieldCount();
        this.parameterTypes_ = new int[n];
        for (int i = 0; i < n; ++i) {
            this.parameterTypes_[i] = -1;
        }
    }

    boolean isInput(int n) throws SQLException {
        int n2;
        if (this.parameterTypes_ == null) {
            this.initParmTypes();
        }
        if (this.parameterTypes_[n2 = n - 1] == -1) {
            try {
                this.parameterTypes_[n2] = this.serverFormat_.getFieldParameterType(n2) & 0xFF;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("07009", dBDataStreamException);
            }
        }
        return this.parameterTypes_[n2] == 240 || this.parameterTypes_[n2] == 242;
    }

    boolean isOutput(int n) throws SQLException {
        int n2;
        if (this.parameterTypes_ == null) {
            this.initParmTypes();
        }
        if (this.parameterTypes_[n2 = n - 1] == -1) {
            try {
                this.parameterTypes_[n2] = this.serverFormat_.getFieldParameterType(n2) & 0xFF;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("07009", dBDataStreamException);
            }
        }
        return this.parameterTypes_[n2] == 241 || this.parameterTypes_[n2] == 242;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        if (this.sqlData_ != null) {
            for (int i = 0; i < this.sqlData_.length; ++i) {
                this.sqlData_[i].updateSettings(sQLConversionSettings);
            }
        }
    }
}

